% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SaveRealTimeSettings.R
\name{SaveRealTimeSettings}
\alias{SaveRealTimeSettings}
\title{Save Configuration for Real-Time Report}
\usage{
SaveRealTimeSettings(reportsuite.ids = "", report1 = list(),
  report2 = list(), report3 = list())
}
\arguments{
\item{reportsuite.ids}{Report Suite ID}

\item{report1}{Real Time Report 1}

\item{report2}{Real Time Report 2}

\item{report3}{Real Time Report 3}
}
\value{
Message returned to console
}
\description{
Sets the metrics and elements (dimensions) on which you want real time
reports enabled via list objects created by BuildRealTimeReportStructure.
Realtime configuration changes take 15 minutes to be reflected in reports.
}
\details{
SaveRealTimeSettings should be called each time you want to modify the
structure of your real-time reports. If you are unsure of your current setup
of your real-time reports, use GetRealTimeSettings to find out your
current setup.

WARNING: This function allows you to change the settings in your Adobe
Analytics UI for all users, so be sure this is what you want to do. Additionally,
submitting this function with only one report will mean other reports are deleted,
you're NOT just changing a single report.

NOTE: If the ui_report parameter is set to false, you must save at least one
element and one metric or the configuration will be invalid, even though an
error does not occur. If the ui_report parameter is set to true, you must
save three elements and one metric or you will receive an error.

Changes can take up to 15 minutes to be reflected.
}
\examples{
\dontrun{

saverealtime <- SaveRealTimeSettings("your-report-suite", report1, report2, report3)

   }
}
\seealso{
\code{\link{GetRealTimeSettings}} \cr

\code{\link{BuildRealTimeReportStructure}} \cr
}
\keyword{SaveRealTimeSettings}

