% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobMethods.R
\name{updateJob}
\alias{updateJob}
\title{Update Job}
\usage{
updateJob(account, username = Sys.getenv("SLUSER"), jobID, name = NULL,
  tags = NULL, public = NULL, passed = NULL, build = NULL,
  custom_data = NULL, ...)
}
\arguments{
\item{account}{An object of class "account". An account object see \code{\link{account}}.}

\item{username}{SauceLabs username}

\item{jobID}{Id of the job to edit}

\item{name}{Change the job name}

\item{tags}{Change the job tags}

\item{public}{Set job visibility to "public", "public restricted", "share" (true), "team" (false) or "private"}

\item{passed}{Set whether the job passed or not on the user end}

\item{build}{The build number tested by this test}

\item{custom_data}{A  set of key-value pairs with any extra info that a user would like to add to the job. Note that the max data allowed is 64KB}

\item{...}{Additonal function arguments - Currently unused.}
}
\description{
Edit an existing job
}
\examples{
\dontrun{
myAcc <- account()
myJobs <- getJobs(myAcc)
#> myJobs$data[1,]
#id
#1: 4152e0a185f945bfa43e091eef1e7c30
myJobs <- getJobs(myAcc, getFullJobs = TRUE)
#> myJobs$data[1,.(id, browser)]
#id      browser
#1: 4152e0a185f945bfa43e091eef1e7c30 googlechrome
testId <- myJobs$data[1, id]

#> myJobs$data[1,.(build, passed)]
#build passed
#1:    24  FALSE

# update this job
updateJob(myAcc, jobID = testId, passed = TRUE, build = 20)
myJobs <- getJobs(myAcc, getFullJobs = TRUE)
#> myJobs$data[1,.(build, passed)]
#build passed
#1:    20   TRUE
# deleteJob(myAcc, jobID = testId)
stopJob(myAcc, jobID = testId)

jobAssets <- getJobAssetNames(myAcc, jobID = testId)
#> jobAssets[["selenium-log"]]
#[1] "selenium-server.log"

jobLog <- getJobAssetFiles(myAcc, jobID = testId)
# deleteJobAssets(myAcc, jobID = testId)
}

}
\seealso{
Other jobMethods: \code{\link{deleteJobAssets}},
  \code{\link{deleteJob}}, \code{\link{getJobAssetFiles}},
  \code{\link{getJobAssetNames}}, \code{\link{getJobs}},
  \code{\link{stopJob}}
}

