% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbolic_objects.R
\name{cov}
\alias{cov}
\alias{cov.default}
\alias{cov.symbolic_interval}
\title{Generic function for the covariance}
\usage{
cov(x, ...)

\method{cov}{default}(
  x,
  y = NULL,
  use = "everything",
  method = c("pearson", "kendall", "spearman"),
  ...
)

\method{cov}{symbolic_interval}(x, y, method = c("centers", "billard"), na.rm = FALSE, ...)
}
\arguments{
\item{x}{First symbolic variables.}

\item{...}{As in R cov function.}

\item{y}{Second symbolic variables.}

\item{use}{an optional character string giving a method for computing
covariances in the presence of missing values. This must be (an abbreviation of)
 one of the strings 'everything', 'all.obs', 'complete.obs', 'na.or.complete',
 or 'pairwise.complete.obs'.}

\item{method}{The method to be use.}

\item{na.rm}{As in R cov function.}
}
\value{
Return a real number.
}
\description{
This function compute the symbolic covariance.
}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Covariance}
\keyword{Symbolic}
