% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym_var.R
\name{sym.var}
\alias{sym.var}
\title{Symbolic Variable (Feature)}
\usage{
sym.var(sym.data, number.sym.var)
}
\arguments{
\item{sym.data}{The symbolic data table}

\item{number.sym.var}{The number of the column for the variable (feature) that we want to get.}
}
\value{
Return a symbolic data variable with the following structure: \cr

$N\cr

[1] 7\cr

$var.name\cr

[1] 'F6'\cr

$var.type\cr

[1] '$I'\cr

$obj.names\cr

[1] 'Case1' 'Case2' 'Case3' 'Case4' 'Case5' 'Case6' 'Case7'\cr

$var.data.vector\cr

F6  F6.1\cr

Case1   0.00 90.00\cr

Case2 -90.00 98.00\cr

Case3  65.00 90.00\cr

Case4  45.00 89.00\cr

Case5  20.00 40.00\cr

Case6   5.00  8.00\cr

Case7   3.14  6.76\cr
}
\description{
This function get a symbolic variable from a symbolic data table.
}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Bock H-H. and Diday E. (eds.) (2000).
Analysis of Symbolic Data. Exploratory methods for extracting statistical information
from complex data. Springer, Germany.
}
\seealso{
sym.obj
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Symbolic}
\keyword{Variable}
