% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.evolvability.test.R
\name{random.evolvability.test}
\alias{random.evolvability.test}
\title{Randomization test for phylogenetic structuring in evolvability}
\usage{
random.evolvability.test(tree,data,node.estimation=c("RR","BM"),
  aces=NULL,iterations=1000,nsim=100,clus=0.5)
}
\arguments{
\item{tree}{a phylogenetic tree. The tree needs not to be ultrametric or
fully dichotomous.}

\item{data}{a matrix or data.frame of phenotypic data having species as rownames}

\item{node.estimation}{specify the method to compute ancestral character at
nodes. It can be one of \code{"RR"}, to compute ancestral states by mean of
\code{RRphylo}, or \code{"BM"}, to use \pkg{phytools}' function \code{fastAnc}
(\cite{Paradis & Schliep 2019}) to estimate ancestral characters at nodes
according to Brownian Motion.}

\item{aces}{a named matrix of known ancestral character values at nodes.
Names correspond to the nodes in the tree.}

\item{iterations}{the iterations argument to be indicated in
\code{MeanMatrixStatistics}}

\item{nsim}{the number of simulations to be performed for the randomization
test, by default \code{nrep} is set at 100.}

\item{clus}{the proportion of clusters to be used in parallel computing. To
run the single-threaded version of \code{NOME} set \code{clus} = 0.}
}
\value{
The function returns a list object including (\code{$means}) the mean
  values for all statistics as produced by \code{MeanMatrixStatistics} and
  (\code{$means}) the significance levels for Respondability, Evolvability,
  and Flexibility.
}
\description{
The function is a wrapper around the function
  \code{\link[evolqg]{MeanMatrixStatistics}} from the package \pkg{evolqg} (\cite{Melo et
  al. 2015}). It estimates ancestral character at internal nodes either
  according to Brownian Motion or by means of \code{\link{RRphylo}} (see the
  argument \code{node.estimation}), then performs \code{MeanMatrixStatistics}
  to calculate: Mean Squared Correlation, ICV, Autonomy,
  ConditionalEvolvability, Constraints, Evolvability, Flexibility,
  Pc1Percent, and Respondability. To assess the importance of phylogenetic
  structuring (signal) on Respondability Evolvability, and Flexibility, the
  function performs a randomization test by randomly shuffling the species on
  tree and replicating the analyses \code{nsim} times. A p-value is computed
  by contrasting the real metrics to the ones derived by randomization.
}
\examples{
 \dontrun{
 library(ape)
 library(phytools)

 rtree(30)->tree
 fastBM(tree,nsim=4)->y

 random.evolvability.test(tree=tree,data=y,node.estimation="RR")->rEvTest

    }
}
\references{
Melo, D., Garcia, G., Hubbe, A., Assis, A. P., & Marroig, G.
  (2015). EvolQG-An R package for evolutionary quantitative genetics.
  \emph{F1000Research}, 4.

Revell, L. J. (2012) phytools: An R package for phylogenetic
  comparative biology (and other things).
  \emph{Methods in Ecology and Evolution}, 3, 217-223.
}
\seealso{
\href{../doc/RRphylo.html}{\code{RRphylo} vignette}
}
\author{
Silvia Castiglione, Gabriele Sansalone, Pasquale Raia
}
