% Generated by roxygen2 (4.0.2): do not edit by hand
\name{DianaPerri1}
\alias{DianaPerri1}
\title{Diana-Perri-1 model}
\usage{
DianaPerri1(z,p,mu,pi,type=c("total","mean"),cl,N=NULL,method="srswr")
}
\arguments{
\item{z}{vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{p}{probability of direct response}

\item{mu}{vector with the means of the scramble variables \eqn{W} and \eqn{U}}

\item{pi}{vector of the first-order inclusion probabilities}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence level}

\item{N}{size of the population. By default it is NULL}

\item{method}{method used to draw the sample: srswr or srswor. By default it is srswr}
}
\value{
Point and confidence estimates of the sensitive characteristics using the Diana-Perri-1 model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence interval through the Diana-Perri-1 model.
The function can also return the transformed variable.
The Diana-Perri-1 model was proposed by Diana and Perri (2010, page 1877).
}
\details{
In the Diana-Perri-1 model let \eqn{p\in [0,1]} be a design parameter, controlled by the experimenter, which is used to randomize the response as follows: with probability
\eqn{p} the interviewer responds with the true value of the sensitive variable, whereas with probability \eqn{1-p} the respondent gives a coded value,
\eqn{z_i=W(y_i+U)} where \eqn{W,U} are scramble variables whose distribution is assumed to be known.

To estimate \eqn{\bar{Y}} a sample of respondents is selected according to simple random sampling with replacement.
The transformed variable is
\deqn{r_i=\frac{z_i-(1-p)\mu_W\mu_U}{p+(1-p)\mu_W}}
where \eqn{\mu_W,\mu_U} are the means of \eqn{W,U} scramble variables, respectively.

The estimated variance in this model is
\deqn{\widehat{V}(\widehat{\bar{Y}}_R)=\frac{s_z^2}{n(p+(1-p)\mu_W)^2}}
where \eqn{s_z^2=\sum_{i=1}^n\frac{(z_i-\bar{z})^2}{n-1}}.

If the sample is selected by simple random sampling without replacement, the estimated variance is
\deqn{\widehat{V}(\widehat{\bar{Y}}_R)=\frac{s_z^2}{n(p+(1-p)\mu_W)^2}\left(1-\frac{n}{N}\right)}
}
\examples{
N=417
data(DianaPerri1Data)
dat=with(DianaPerri1Data,data.frame(z,Pi))
p=0.6
mu=c(5/3,5/3)
cl=0.95
DianaPerri1(dat$z,p,mu,dat$Pi,"mean",cl,N,"srswor")
}
\references{
Diana, G., Perri, P.F. (2010).
\emph{New scrambled response models for estimating the mean of a sensitive quantitative character.}
Journal of Applied Statistics 37 (11), 1875–1890.
}
\seealso{
\code{\link{DianaPerri1Data}}

\code{\link{DianaPerri2}}

\code{\link{ResamplingVariance}}
}
\keyword{Confidence_interval}
\keyword{DianaPerri}
\keyword{Estimation}
\keyword{Quantitative}
\keyword{Randomized_response}
\keyword{Transformed_variable}
\keyword{Variance}

