% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{pca_kmeans}
\alias{pca_kmeans}
\title{pca_kmeans}
\usage{
pca_kmeans(
  data,
  do.k.means = TRUE,
  k.clust = 2,
  clust.names = c("Cluster1", "Cluster2"),
  sel.Gene = "all",
  point.size = 4,
  point.shape = c(19, 17),
  alpha = 0.7,
  point.color = c("#66c2a5", "#fc8d62"),
  add.sample.labels = FALSE,
  label.size = 3,
  hjust = 0,
  vjust = -1,
  axis.title.size = 11,
  axis.text.size = 10,
  legend.text.size = 11,
  legend.title.group = "Group",
  legend.title.cluster = "Cluster",
  legend.title.size = 11,
  legend.position = "right",
  plot.title = "",
  plot.title.size = 14,
  save.to.tiff = FALSE,
  dpi = 600,
  width = 15,
  height = 15,
  name.tiff = "pca_and_kmeans"
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready() or delta_Ct() functions.}

\item{do.k.means}{Logical: if TRUE (default), k means analysis will be performed.}

\item{k.clust}{Integer: number of clusters for k means analysis. Default to 2.}

\item{clust.names}{Character vector with names of clusters, must be equal to the number of clusters specified in the k.clust parameter.}

\item{sel.Gene}{Character vector with names of genes to include, or "all" (default) to use all genes.}

\item{point.size}{Numeric: size of points. Default to 4.}

\item{point.shape}{Integer: shape of points. If do.k.means = TRUE, the number of provided values must be equal to the
number of cluster (k.clust). Default to c(19, 17).}

\item{alpha}{Numeric: transparency of points, a value between 0 and 1. Default to 0.7.}

\item{point.color}{Character vector containing colors for compared groups. The number of colors must be equal to the number of groups. Default to c("#66c2a5", "#fc8d62").}

\item{add.sample.labels}{Logical: if TRUE, points labels (names of samples) will be added. Default to FALSE.}

\item{label.size}{Numeric: size of points labels (names of samples). Default to 3.}

\item{hjust}{Numeric: horizontal position of points labels. Default to 0.}

\item{vjust}{Numeric: vertical position of points labels.  Default to -1.}

\item{axis.title.size}{Integer: font size of axis titles. Default to 11.}

\item{axis.text.size}{Integer: font size of axis text. Default to 10.}

\item{legend.text.size}{Integer: font size of legend text. Default to 11.}

\item{legend.title.group}{Character: title of legend for groups. Default to "Group".}

\item{legend.title.cluster}{Character: title of legend for k means clusters. Default to "Clusters".}

\item{legend.title.size}{Integer: font size of legend title. Default to 11.}

\item{legend.position}{Position of the legend, can be "top", "right" (default), "bottom", "left", or "none" (no legend).
See description for legend.position parameter in ggplot2::theme() function.}

\item{plot.title}{Character: title of plot. Default to "".}

\item{plot.title.size}{Integer: font size of plot title. Default to 14.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{name.tiff}{character: name of saved .tiff file, without ".tiff" name of extension. Default to "pca_and_kmeans".}
}
\value{
A list containing object with plot and, if do.k.means = TRUE, a confusion matrix that show classification performance of k means method.
Created plot is also displayed on the graphic device.
}
\description{
This function performs principal component analysis (PCA) together with k means analysis for samples,
and generate plot that illustrate spatial arrangement of samples based on the two first components and with assignment to k means clusters.
PCA analysis can not deal with missing values, thus all samples with at least one missing value are removed from data before analysis.
}
\examples{
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "Gene8")
pca_kmeans(data.dCt, sel.Gene = c("Gene1","Gene16","Gene19","Gene20"))

}
