% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{parallel_plot}
\alias{parallel_plot}
\title{parallel_plot}
\usage{
parallel_plot(
  data,
  sel.Gene = "all",
  scale = "globalminmax",
  alpha = 0.7,
  custom.colors = FALSE,
  order = "anyClass",
  colors,
  linewidth = 1,
  show.points = TRUE,
  x.axis.title = "",
  y.axis.title = "value",
  axis.title.size = 11,
  axis.text.size = 10,
  legend.text.size = 11,
  legend.title = "Gene",
  legend.title.size = 11,
  legend.position = "top",
  plot.title = "",
  plot.title.size = 14,
  save.to.tiff = FALSE,
  dpi = 600,
  width = 15,
  height = 15,
  name.tiff = "parallel_plot"
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready(), exp_Ct_dCt() or delta_Ct() functions.}

\item{sel.Gene}{Character vector with names of genes to include, or "all" (default) to use all genes.}

\item{scale}{Character: a scale used for data presentation, one of the passed to ggparcoord() function.
Generally, scaling is not required since variables are the same units. Default to "globalminmax (no scaling).}

\item{alpha}{Numeric: transparency of lines, a value between 0 and 1. Default to 0.7.}

\item{custom.colors}{Logical: if custom vector colors for genes is provided (and passed to the colors parameter),
it should be set to TRUE. For default colors, use custom.colors = FALSE (default).}

\item{order}{Character: method for groups ordering, one of the used in the ggparcoord() function. Default to 'anyClass'.
Must either be a vector of column indices (obligatory if only one gene is plotted), starting from 3 (e.g., for two groups it can be c(3,4) or c(4,3)),
or one of 'skewness', 'allClass', 'anyClass' (default), as well as scagnostic measures available in the 'scagnostics'
package (must be loaded): 'Outlying', `Skewed', 'Clumpy', 'Sparse', 'Striated', 'Convex', 'Skinny', 'Stringy', 'Monotonic'.}

\item{colors}{Character vector containing custom colors for genes.
The number of colors must be equal to the number of presented genes. Must be provided if custom.colors = TRUE.}

\item{linewidth}{Numeric: width of lines. Default to 1.}

\item{show.points}{Logical: if TRUE (default), points will be also shown.}

\item{x.axis.title}{Character: title of x axis. Default to "".}

\item{y.axis.title}{Character: title of y axis. Default to "value".}

\item{axis.title.size}{Integer: font size of axis titles. Default to 11.}

\item{axis.text.size}{Integer: font size of axis text. Default to 10.}

\item{legend.text.size}{Integer: font size of legend text. Default to 11.}

\item{legend.title}{Character: title of legend for groups. Default to "Gene".}

\item{legend.title.size}{Integer: font size of legend title. Default to 11.}

\item{legend.position}{Position of the legend, can be "top", "right" (default), "bottom", "left", or "none" (no legend).
See description for legend.position parameter in ggplot2::theme() function.}

\item{plot.title}{Character: title of plot. Default to "".}

\item{plot.title.size}{Integer: font size of plot title. Default to 14.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{name.tiff}{character: name of saved .tiff file, without ".tiff" name of extension. Default to "pca_and_kmeans".}
}
\value{
An object with plot. Created plot is also displayed on the graphic device.
}
\description{
This function illustrates expression values in a pairwise samples as series of lines connected across each axis.
This function can be used only for a pairwise data.
}
\examples{
library(tidyverse)
library(GGally)
data(data.Ct.pairwise)
data.CtF.pairwise <- filter_Ct(data = data.Ct.pairwise,
                               flag.Ct = "Undetermined",
                               maxCt = 35,
                               flag = c("Undetermined"),
                               remove.Gene = c("Gene9", "Gene2","Gene5", "Gene11","Gene1"))
data.CtF.ready.pairwise <- make_Ct_ready(data = data.CtF.pairwise,
                                         imput.by.mean.within.groups = TRUE)
data.dCt.pairwise <- delta_Ct(data = data.CtF.ready.pairwise,
                              ref = "Gene4")
parallel.plot <- parallel_plot(data = data.dCt.pairwise,
                               sel.Gene = c("Gene8","Gene19"))

}
