% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{RQ_exp_Ct_dCt}
\alias{RQ_exp_Ct_dCt}
\title{RQ_exp_Ct_dCt}
\usage{
RQ_exp_Ct_dCt(
  data,
  group.study,
  group.ref,
  do.tests = TRUE,
  pairwise = FALSE,
  alternative = "two.sided",
  p.adjust.method = "BH",
  save.to.txt = FALSE,
  name.txt = "RQ_exp_results"
)
}
\arguments{
\item{data}{Data object returned from exp_Ct_dCt() function.}

\item{group.study}{Character: name of study group (group of interest).}

\item{group.ref}{Character: name of reference group.}

\item{do.tests}{Logical: if TRUE, statistical significance of differences between compared groups will be calculated using Student's t test and Mann-Whitney U test. Default to TRUE.}

\item{pairwise}{Logical: if TRUE, a pairwise analysis will be performed (see details). Default to FALSE.}

\item{alternative}{Character: alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{p.adjust.method}{Character: p value correction method for multiple testing, one of the "holm", "hochberg", "hommel",
"bonferroni", "BH" (default), "BY","fdr", or "none". See documentation for stats::p.adjust() function for details.}

\item{save.to.txt}{Logical: if TRUE, returned table with results will be saved to .txt file. Default to FALSE.}

\item{name.txt}{Character: name of saved .txt file, without ".txt" name of extension. Default to "RQ_exp_results".}
}
\value{
Data frame with results (if pairwise = FALSE) or, if pairwise = TRUE, the list object
with two elements: a table with the results and the second table with fold change values calculated individually for each sample.
}
\description{
This function performs relative quantification of gene expression using 2^-Ct and 2^-dCt methods.
}
\details{
This function calculates:
1. Means (returned in columns with the "_mean" pattern) and standard deviations (returned in columns with the "_sd" pattern)
of exponentiated Ct or dCt values of analyzed genes across compared groups.
2. P values of normality test (Shapiro_Wilk test) performed on exponentiated Ct or dCt values across compared groups (returned in columns with the "_norm_p" pattern).
3. Fold change values (returned in "FCh" column) calculated for each gene by dividing  mean of exponentiated Ct od dCt values in study group
by mean of exponentiated Ct or dCt values in reference group.
4. Statistics (returned in column with the "_test_stat" pattern) and p values (returned in column with "_test_p" pattern) of
differences in exponentiated Ct or dCt values between study group and reference group using Student's t test and Mann-Whitney U test.
}
\examples{
library(tidyverse)
library(coin)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                     remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                     remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.Ct.exp <- exp_Ct_dCt(data.CtF.ready)
RQ.Ct.exp <- RQ_exp_Ct_dCt(data.Ct.exp,
                           group.study = "Disease",
                           group.ref = "Control")
head(RQ.Ct.exp)

}
