% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{demoProject}
\alias{demoProject}
\title{Demonstration project}
\usage{
demoProject(cs_dir = tempdir(TRUE))
}
\arguments{
\item{cs_dir}{An optional character string specifying an existing directory.}
}
\value{
A character string containing the demonstration project root
directory.
}
\description{
Copies a demonstration project to an existing or a temporary directory.

The demonstration project data are a derivative of the
\itemize{
\item \emph{\href{https://www.data.gv.at/katalog/dataset/d88a1246-9684-480b-a480-ff63286b35b7}{Geoland.at}} (digital elevation model),
\item \emph{\href{https://www.data.gv.at/katalog/dataset/35e36014-ec69-439b-8629-389f52ffaa92}{AMA}} (field data),
\item \emph{\href{https://www.data.gv.at/katalog/dataset/c2287ccb-f44c-48cd-bf7c-ac107b771246}{BMLRT}} (channel data) and
\item \emph{\href{https://www.data.gv.at/katalog/dataset/3fefc838-791d-4dde-975b-a4131a54e7c5}{GIP.at}} (road data)
}

data sets, used and licensed under \emph{\href{https://creativecommons.org/licenses/by/4.0/}{(CC BY 4.0)}} by Gerold Hepp.

While the data represent a real catchment \emph{\href{https://hoal.hydrology.at/}{(HOAL)},} some of them are fictitious, but plausible. These are, among others, R- and C-factors, soil and related data, existence of subsurface drainage at road embankments as well as substance river loads.
}
\examples{

demoProject()

}
\seealso{
\code{\link{RPhosFate}}, \code{\link{catchment}}
}
