% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROlogit.R
\name{hresid}
\alias{hresid}
\title{Obtain the heuristic residuals.}
\usage{
hresid(y, svar, design.mat, o, initial.res.par = c(0, 0), ...)
}
\arguments{
\item{y}{vector of numeric. The outcomes.}

\item{svar}{vector of numeric. The strata variable.}

\item{design.mat}{matrix. The design matrix including intercept term.}

\item{o}{matrix. Contains the estimated coefficients of the RO-logit and
their SEs.}

\item{initial.res.par}{The initial values of the intercept and log(scale), to
be passed to the \code{optim} function. The default values are set to
\code{c(0, 0)}, yet users are recommended to try a few initial values to
make sure global optimum is reached.}

\item{...}{Other parameters to be passed to the \code{optim} function. See
\code{\link[stats]{optim}} for details.}
}
\value{
Returns a list containing the estimated intercept and
  \code{log(scale)}, the covariance matrix of these two parameters,
  convergence status from \code{optim}, and the heuristic residuals.
}
\description{
Obtain the heuristic residuals.
}
