% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{saveTransform}
\alias{saveTransform}
\alias{loadTransform}
\title{Save and load transform objects}
\usage{
saveTransform(transform, fileName = NULL)

loadTransform(x)
}
\arguments{
\item{transform}{A transform, possibly obtained from \code{\link{forward}}
or \code{\link{reverse}}.}

\item{fileName}{The file name to save to. If \code{NULL}, the serialised
object is returned directly instead.}

\item{x}{A file name to read from, or a serialised transform object.}
}
\value{
\code{saveTransform} returns a serialised transform object, if no
  filename is given; otherwise it is called for its side-effect of writing
  to file. \code{loadTransform} returns a deserialised transform object.
}
\description{
These objects save a full transformation object, including source and target
image metadata, to a self-contained RDS file, or load it back from such a
file.
}
\seealso{
\code{\link{writeAffine}}, \code{\link{readAffine}}
}
\author{
Jon Clayden <code@clayden.org>
}
