% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{isImage}
\alias{isImage}
\title{Test whether an object represents an image}
\usage{
isImage(object, unsure = NA)
}
\arguments{
\item{object}{An R object.}

\item{unsure}{The value to return if the function can't tell whether or not
the \code{object} is an image.}
}
\description{
This function tried to determine whether an object is an image that the
package knows how to handle. If its class is \code{"nifti"},
\code{"niftiImage"} or \code{"internalImage"}, then the result is always
\code{TRUE}. Likewise if it has an internal image pointer (although in that
case it should also be of class \code{"niftiImage"}). If it has no
\code{dim} attribute, or looks like an affine matrix, then the result is
\code{FALSE}. Otherwise the value of the \code{unsure} argument is returned.
}
\author{
Jon Clayden <code@clayden.org>
}

