% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nexml_add.R
\name{nexml_add}
\alias{nexml_add}
\title{add elements to a new or existing nexml object}
\usage{
nexml_add(x, nexml = new("nexml"), type = c("trees", "characters", "meta",
  "namespaces"), ...)
}
\arguments{
\item{x}{the object to be added}

\item{nexml}{an existing nexml object onto which the object should be appended}

\item{type}{the type of object being provided.}

\item{...}{additional optional arguments to the add functions}
}
\value{
a nexml object with the additional data
}
\description{
add elements to a new or existing nexml object
}
\examples{
library("geiger")
data(geospiza)
geiger_nex <- nexml_add(geospiza$phy, type="trees")
geiger_nex <- nexml_add(geospiza$dat, nexml = geiger_nex, type="characters")
}
\seealso{
\code{\link{add_trees}} \code{\link{add_characters}} \code{\link{add_meta}} \code{\link{add_namespaces}}
}
