% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/extension.R
\docType{methods}
\name{dbEscapeStrings}
\alias{dbEscapeStrings}
\alias{dbEscapeStrings,MySQLConnection,character-method}
\alias{dbEscapeStrings,MySQLResult,character-method}
\title{Escape SQL-special characters in strings.}
\usage{
dbEscapeStrings(con, strings, ...)

\S4method{dbEscapeStrings}{MySQLConnection,character}(con, strings)

\S4method{dbEscapeStrings}{MySQLResult,character}(con, strings, ...)
}
\arguments{
\item{con}{a connection object (see \code{\link[DBI]{dbConnect}}).}

\item{strings}{a character vector.}

\item{...}{any additional arguments to be passed to the dispatched method.}
}
\value{
A character vector with SQL special characters properly escaped.
}
\description{
Escape SQL-special characters in strings.
}
\examples{
if (mysqlHasDefault()) {
con <- dbConnect(RMySQL::MySQL(), dbname = "test")

tmp <- sprintf("SELECT * FROM emp WHERE lname = \%s", "O'Reilly")
dbEscapeStrings(con, tmp)

dbDisconnect(con)
}
}

