% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/utility.r
\name{MS_popan}
\alias{MS_popan}
\title{Convert Multistate data for POPAN-style abundance estimation}
\usage{
MS_popan(x, augment_num = 100, augment_stratum = "A", enter_stratum = "B",
  strata = NULL, begin.time = 1, groups = NULL, ddl = FALSE,
  time.intervals = NULL)
}
\arguments{
\item{x}{an RMark dataframe}

\item{augment_num}{the number to add with a capture history of all 0s; this is the expected number that were in the population and not ever seen}

\item{augment_stratum}{the single character to represent outside of the population; use a value not used in the data capture history}

\item{enter_stratum}{the single character to represent inside of the population but not yet entered; use a value not used in the data capture history}

\item{strata}{vector of single characters for observed and unobserved states}

\item{begin.time}{beginning time of observed occasions; two occasions are added to the fron of the capture history at times begin.time-1 and begin.time-2}

\item{groups}{vector of character variable names of factor variables to use for grouping}

\item{ddl}{if TRUE, will return processed data and a design data list with the appropriate fixed parameters.}

\item{time.intervals}{intervals of time between observed occasions}
}
\description{
Converts data and optionally creates and structures design data list
such that population size can be derived with multistate data. Variance estimate is questionable.
}
\examples{
\donttest{
data(dipper)
popan_N=summary(mark(dipper,model="POPAN",
        model.parameters=list(pent=list(formula=~time))),se=TRUE)$reals$N
data.list=MS_popan(dipper,ddl=TRUE,augment_num=30)
modMS=mark(data.list$data,data.list$ddl,
        model.parameters=list(Psi=list(formula=~B:toB:time)),brief=TRUE)
Psi_estimates=summary(modMS,se=TRUE)$reals$Psi
Nhat_MS=Psi_estimates$estimate[1]*sum(abs(data.list$data$data$freq))
se_Nhat_MS=Psi_estimates$se[1]*Nhat_MS
cat("Popan N = ",popan_N$estimate," (se = ",popan_N$se,")\\n")
cat("MS N = ",Nhat_MS," (se = ",se_Nhat_MS,")\\n")
}
}
\author{
Jeff Laake
}

