% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMPSolveH.R
\name{RMPSolveH}
\alias{RMPSolveH}
\title{Recursive Modified Direct Search on Hyper-rectangle}
\usage{
RMPSolveH(
  x0,
  func,
  lb,
  ub,
  rho_1 = 2,
  rho_2 = 2,
  phi = 1e-06,
  no_runs = 1000,
  max_iter = 10000,
  s_init = 2,
  tol_fun = 1e-06,
  tol_fun_2 = 1e-20,
  max_time = 36000,
  print_output = FALSE
)
}
\arguments{
\item{x0}{Vector of Initial Guess provided by User.}

\item{func}{The Function to be Optimized, should be provided by the User.}

\item{lb}{Vector of Lower Bounds, of same Dimension as 'x0'.}

\item{ub}{Vector of Upper Bound, of same Dimension as 'x0'}

\item{rho_1}{'Step Decay Rate' for the First Run Only (Default is 2).}

\item{rho_2}{'Step Decay Rate' for Second Run Onwards (Default is 2).}

\item{phi}{Lower Bound for 'Global Step Size'. Default value is \eqn{10^{-6}}.}

\item{no_runs}{Max Number of 'Runs'. Default Value is 1000.}

\item{max_iter}{Max Number of Iterations in each 'Run'. Default Value is 10000.}

\item{s_init}{Initial  'Global Step Size'. Default Value is 2. It must be set Less than or Equal to 2.}

\item{tol_fun}{Termination Tolerance on when to decrease the 'Global Step Size'. Default Value is \eqn{10^{-6}}. For more accuracy, user may set it to a Smaller Value
e.g., \eqn{10^{-20}}. However, for Expensive Objective Functions, for Faster Computation, User should set it to a Larger Value e.g, \eqn{10^{-3}}.}

\item{tol_fun_2}{Termination Tolerance on the Difference of Norms of solution points in two Consecutive Runs. Default Value is \eqn{10^{-20}}.
However, for Expensive Objective Functions, for Faster Computation, user should set it to a Larger Value e.g, \eqn{10^{-6}}.}

\item{max_time}{Time Alloted (In Seconds) for Execution of RMPSH. Default is 36000 secs (10 Hours).}

\item{print_output}{Binary Command to Print Optimized Value of Objective Function after Each Iteration. Default is set as FALSE.}
}
\value{
The Optimal Solution Point.
}
\description{
`RMPSolveH` can be Used to Minimize any Non-Convex Blackbox Function where Each Parameter
has an Upper Bound and Lower Bound.
}
\examples{

g <- function(y)
 return(-20 * exp(-0.2 * sqrt(0.5 * (y[1] ^ 2 + y[2] ^ 2))) -
 exp(0.5 * (cos(2 * pi * y[1]) + cos(2 * pi * y[2]))) + exp(1) + 20)

starting_point <- rep(1, 10)

g(starting_point)

solution <- RMPSolveH(starting_point, g, rep(-33, 10), rep(33, 10))

g(solution)

RMPSolveH(c(2, 4, 6, 2, 1), g, rep(-3, 5), rep(23, 5), print_output = TRUE)
# Will Print the Updates after Each Iteration


g <- function(y)
 return(sum(y ^ 2))
RMPSolveH(rep(2.3, 100),
          g,
          rep(-11, 100),
          rep(13, 100),
          max_time = 2,
          print = 1)
# Will Exit and Return Result after 2 Seconds

}
\references{
\itemize{

  \item Das, Priyam \cr
   "Black-box optimization on hyper-rectangle using Recursive Modified Pattern Search and application to ROC-based Classification Problem" \cr
         (available at `arXiv \url{http://arxiv.org/abs/1604.08616}).
}
}
