% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrometheeS4.R
\name{RPrometheeConstructor}
\alias{RPrometheeConstructor}
\alias{RPrometheeArguments}
\title{RPrometheeConstructor}
\usage{
RPrometheeConstructor(datMat, vecWeights, vecMaximiz, prefFunction, parms,
  normalize, alphaVector = NULL, band = NULL, constraintDir = NULL,
  bounds = NULL, alternatives = NULL, criterias = NULL)
}
\arguments{
\item{datMat}{A matrix containing the data from criterias and alternatives.}

\item{vecWeights}{A vector of weights for each criteria.}

\item{vecMaximiz}{A logical vector to indicate if the criteria should be
maximized or minimized.}

\item{prefFunction}{A numerical vector to indicate the type of the
Preference Function:
  \itemize{
    \item \code{prefFunction=0}  Gaussian Preference Function
    \item \code{prefFunction=1}  Usual Preference Function
    \item \code{prefFunction=2}  U-Shape Preference Function
    \item \code{prefFunction=3}  V-Shape Preference Function
    \item \code{prefFunction=4}  Level Preference Function
    \item \code{prefFunction=5}  V-Shape Preference and Indiference Function
    }}

\item{parms}{a numerical matrix with parameters associated to the Preference
Function. They're defined as a matrix of n columns and m rows. The maximum
number of parameters is 3 and m is the number of criterias. The parameters
are:
 \itemize{
   \item{Indifference Threshold (\code{q})}
   \item{Preference Threshold (\code{p})}
   \item{Gaussian Threshold (\code{s})}
 }}

\item{normalize}{A boolean to normalize the index.}

\item{alphaVector}{A numerical vector to indicate the size of the interval
for each alternative in Promethee III ranking.}

\item{band}{A numerical matrix with m rows corresponding to each criteria
and one column corresponding to the bandwitch estimated for that criteria.
This bandwitch is used for Kernel Density Estimation in Promethee IV Kernel.
By default, it is calculated using \code{bw.nrd0}.}

\item{constraintDir}{A character vector with the direction of constraints to
be optimized in Promethee V. The values must be combinations of \code{>},
\code{<} and \code{=} operators. If missing, it's calculated using
\code{"<="} for all criterias.}

\item{bounds}{A numeric vector used in Promethee V for the right-hand sides
of the constraints.}

\item{alternatives}{A character vector with alternatives names.}

\item{criterias}{A character vector with criterias names.}
}
\description{
Create a \code{RPrometheeArguments} object to be used by \code{RPromethee}
  methods.
}
\details{
This function is used to create a \code{RPrometheeArguments} object. This
  object is used by all RPromethee methods, being necessary to include only
  the arguments that are used by the desired method. The arguments
  \code{datMat}, \code{vecWeights}, \code{vecMaximiz}, \code{prefFunction},
  \code{parms}, \code{normalize} must be specified for all methods. The
  following methods use additional arguments:
  \itemize{
    \item{\code{RPrometheeIII} uses \code{alphaVector}}
    \item{\code{RPrometheeIVKernel} uses \code{band}}
    \item{\code{RPrometheeV} uses \code{constraintDir} and \code{bounds}}
  }
}
\seealso{
\code{\link{RPrometheeI}}, \code{\link{RPrometheeII}},
 \code{\link{RPrometheeIII}}, \code{\link{RPrometheeIV}},
 \code{\link{RPrometheeIVKernel}}, \code{\link{RPrometheeV}}

Other RPromethee methods: \code{\link{PrometheeIIIPlot}},
  \code{\link{PrometheeIIPlot}},
  \code{\link{PrometheeIPlot}},
  \code{\link{PrometheeIVPlot}},
  \code{\link{RPrometheeIII}}, \code{\link{RPrometheeII}},
  \code{\link{RPrometheeIVKernel}},
  \code{\link{RPrometheeIV}}, \code{\link{RPrometheeI}},
  \code{\link{RPrometheeV}},
  \code{\link{SensitivityAnalysis}},
  \code{\link{UpdateRPrometheeAlternatives}},
  \code{\link{UpdateRPrometheeArguments}},
  \code{\link{WalkingWeightsPlot}},
  \code{\link{plot,RPrometheeI-method}}
}
\author{
Pedro Henrique Melo Albuquerque, \email{pedroa@unb.br}

Gustavo Monteiro Pereira, \email{monteirogustavop@gmail.com}
}
\keyword{decision-method}
