% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPCA.R
\name{GPCA}
\alias{GPCA}
\title{This function makes a Gaussianization procedure based on PCA iteration ( see \code{\link{GPCA_iteration}})}
\usage{
GPCA(x_prev, n = 30, extremes = TRUE)
}
\arguments{
\item{x_prev}{previous set of the random variable \code{x}. If it is a \code{varest} object, the residuals are taken into account.}

\item{n}{number of reiterations}

\item{extremes}{see \code{\link{normalizeGaussian_severalstations}}}
}
\value{
A  \code{\link{GPCA-class}} S3 object returned by \code{\link{GPCA_iteration}} at each iteration 
			and the final results of the G-PCA procedure (matrix \code{final_results})
}
\description{
This function makes a Gaussianization procedure based on PCA iteration ( see \code{\link{GPCA_iteration}})
}
\note{
This function re-iterates the equation (1) of "PCA Gaussianization for One-Class Remote Sensing Image" by V. Laparra et al., \url{http://www.uv.es/lapeva/papers/SPIE09_one_class.pdf},\url{http://www.uv.es/vista/vistavalencia/papers/SPIE_09_Gaussianization_presentation.pdf}
}
\examples{
library(RMAWGEN)
set.seed(1222)
nIterations <- 30
N <- 20
x <- rexp(N)
y <- x+rnorm(N)
df <- data.frame(x=x,y=y)

GPCA <- GPCA(df,n=nIterations,extremes=TRUE)

x <- rnorm(N)
y <- x+rnorm(N)
dfn <- data.frame(x=x,y=y)

GPCAn <- GPCA(dfn,n=nIterations,extremes=TRUE)


}
\seealso{
\code{\link{GPCA}},\code{\link{GPCA_iteration}},\code{\link{inv_GPCA_iteration}},\code{\link{inv_GPCA}},\code{\link{GPCA-class}} for 'GPCA' S3 class
}
\author{
Emanuele Cordano
}
