/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RDFSRuleInfGraph
extends FBRuleInfGraph {
    protected HashMap dtRange = null;

    public RDFSRuleInfGraph(Reasoner reasoner, List rules, Graph schema) {
        super(reasoner, rules, schema);
    }

    public RDFSRuleInfGraph(Reasoner reasoner, List rules, Graph schema, Graph data) {
        super(reasoner, rules, schema, data);
    }

    public ValidityReport validate() {
        StandardValidityReport report = (StandardValidityReport)super.validate();
        HashMap dtRange = this.getDTRange();
        Iterator props = dtRange.keySet().iterator();
        while (props.hasNext()) {
            Node prop = (Node)props.next();
            ExtendedIterator i = this.find(null, prop, null);
            while (i.hasNext()) {
                Triple triple = (Triple)i.next();
                report.add(this.checkLiteral(prop, triple.getObject()));
            }
        }
        return report;
    }

    public ValidityReport.Report checkLiteral(Node prop, Node value) {
        List range = (List)this.getDTRange().get(prop);
        if (range != null) {
            if (value.isBlank()) {
                return null;
            }
            if (!value.isLiteral()) {
                return new ValidityReport.Report(true, "dtRange", "Property " + prop + " has a typed range but was given a non literal value " + value);
            }
            LiteralLabel ll = value.getLiteral();
            Iterator i = range.iterator();
            while (i.hasNext()) {
                RDFDatatype dt = (RDFDatatype)i.next();
                if (dt.isValidLiteral(ll)) continue;
                return new ValidityReport.Report(true, "dtRange", "Property " + prop + " has a typed range " + dt + "that is not compatible with " + value);
            }
        }
        return null;
    }

    private HashMap getDTRange() {
        if (this.dtRange == null) {
            this.dtRange = new HashMap();
            ExtendedIterator i = this.find(null, RDFS.range.asNode(), null);
            while (i.hasNext()) {
                RDFDatatype dt;
                Triple triple = (Triple)i.next();
                Node prop = triple.getSubject();
                Node rangeValue = triple.getObject();
                if (!rangeValue.isURI() || (dt = TypeMapper.getInstance().getTypeByName(rangeValue.getURI())) == null) continue;
                ArrayList<RDFDatatype> range = (ArrayList<RDFDatatype>)this.dtRange.get(prop);
                if (range == null) {
                    range = new ArrayList<RDFDatatype>();
                    this.dtRange.put(prop, range);
                }
                range.add(dt);
            }
        }
        return this.dtRange;
    }
}

