/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.ModelSpecCreator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.InfModelSpec;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecCreatorByClassname;
import com.hp.hpl.jena.rdf.model.impl.PlainModelSpec;
import com.hp.hpl.jena.rdf.model.impl.RDBModelSpec;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import java.util.HashMap;
import java.util.Map;

public class ModelSpecCreatorRegistry {
    protected Map creators = new HashMap();
    public static final ModelSpecCreatorRegistry instance = new ModelSpecCreatorRegistry("etc/modelspec-config.n3", true);

    public ModelSpecCreatorRegistry() {
    }

    public ModelSpecCreatorRegistry(String name) {
        this(name, false);
    }

    public ModelSpecCreatorRegistry(String name, boolean ignoreMissingModel) {
        this();
        this.addFromModelNamed(name, ignoreMissingModel);
    }

    public static ModelSpecCreatorRegistry registryWith(Resource type, ModelSpecCreator c) {
        ModelSpecCreatorRegistry result = new ModelSpecCreatorRegistry();
        result.registerCreator(type, c);
        return result;
    }

    public ModelSpecCreator getCreator(Resource type) {
        return (ModelSpecCreator)this.creators.get(type);
    }

    public static ModelSpecCreator findCreator(Resource type) {
        return instance.getCreator(type);
    }

    public void registerCreator(Resource type, ModelSpecCreator c) {
        this.creators.put(type, c);
    }

    public static void register(Resource type, ModelSpecCreator c) {
        instance.registerCreator(type, c);
    }

    protected void addFromModelNamed(String name, boolean ignoreMissingModel) {
        block3: {
            try {
                Model m = FileManager.get().loadModel(name);
                StmtIterator it = m.listStatements(null, JenaModelSpec.typeCreatedBy, (RDFNode)null);
                while (it.hasNext()) {
                    this.addFromStatement(it.nextStatement());
                }
            }
            catch (NotFoundException e) {
                if (ignoreMissingModel) break block3;
                throw e;
            }
        }
    }

    protected void addFromStatement(Statement s) {
        this.registerCreator(s.getSubject(), new ModelSpecCreatorByClassname(s.getString()));
    }

    static {
        ModelSpecCreatorRegistry.register(JenaModelSpec.InfModelSpec, new InfSpecCreator());
        ModelSpecCreatorRegistry.register(JenaModelSpec.OntModelSpec, new OntSpecCreator());
        ModelSpecCreatorRegistry.register(JenaModelSpec.PlainModelSpec, new PlainSpecCreator());
        ModelSpecCreatorRegistry.register(JenaModelSpec.RDBModelSpec, new RDBSpecCreator());
        ModelSpecCreatorRegistry.register(JenaModelSpec.ModelSpec, new PlainSpecCreator());
        ModelSpecCreatorRegistry.register(JenaModelSpec.DefaultModelSpec, new PlainSpecCreator());
    }

    static class OntSpecCreator
    implements ModelSpecCreator {
        OntSpecCreator() {
        }

        public ModelSpec create(Resource root, Model desc) {
            return new OntModelSpec(root, desc);
        }
    }

    static class RDBSpecCreator
    implements ModelSpecCreator {
        RDBSpecCreator() {
        }

        public ModelSpec create(Resource root, Model desc) {
            return new RDBModelSpec(root, desc);
        }
    }

    static class PlainSpecCreator
    implements ModelSpecCreator {
        PlainSpecCreator() {
        }

        public ModelSpec create(Resource root, Model desc) {
            return new PlainModelSpec(root, desc);
        }
    }

    static class InfSpecCreator
    implements ModelSpecCreator {
        InfSpecCreator() {
        }

        public ModelSpec create(Resource root, Model desc) {
            return new InfModelSpec(root, desc);
        }
    }
}

