% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset05}
\alias{dataset05}
\title{John Thompson FROC dataset}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1:2, 1:9, 1:92, 1:7], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1:2, 1:9, 1:47, 1:3], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:47], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:47, 1:3], numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:47, 1:3], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "dataset05", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "FROC", the data type}
\item{\code{descriptions$name}}{, chr "THOMPSON", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, num [1:2, 1:9, 1:92, 1:4], truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr [1:2] "1" "2", treatment labels}
\item{\code{descriptions$readerID}}{, chr [1:4] "1" "2" "3" "4", reader labels}
}
}
\usage{
dataset05
}
\description{
This is referred to in the book as the "JT" dataset. It consists of 92 cases, 47 of 
which are diseased, interpreted in two treatments 
("1" = CT images acquired for attenuation correction, "2" = diagnostic CT images), by nine 
radiographers using the FROC paradigm. Each case was a slice of an anthropomorphic phantom
47 with inserted nodular lesions (max 3 per slice). The maximum number of NLs per case, over the entire 
dataset was 7.
}
\examples{
str(dataset05)
PlotEmpiricalOperatingCharacteristics(dataset = dataset05, opChType = "wAFROC")$Plot


}
\references{
Thompson JD  Hogg P, et al. (2014) A Free-Response Evaluation Determining Value in 
the Computed Tomography Attenuation Correction Image for Revealing Pulmonary 
Incidental Findings: A Phantom Study. Academic Radiology, 21 (4): 538-545.
}
\keyword{datasets}
