% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SsPowerGivenJK.R
\name{SsPowerGivenJK}
\alias{SsPowerGivenJK}
\title{Statistical power for specified numbers of readers and cases}
\usage{
SsPowerGivenJK(
  dataset,
  ...,
  FOM,
  J,
  K,
  effectSize = NULL,
  method = "OR",
  analysisOption = "RRRC",
  LegacyCode = FALSE,
  alpha = 0.05
)
}
\arguments{
\item{dataset}{The \bold{pilot} dataset. If set to NULL 
then variance components must be supplied.}

\item{...}{Optional variance components. These are needed if \code{dataset} 
is not supplied.}

\item{FOM}{The figure of merit}

\item{J}{The number of readers in the pivotal study.}

\item{K}{The number of cases in the pivotal study.}

\item{effectSize}{The effect size to be used in the \strong{pivotal} study.
Default is NULL, which uses the observed effect size in the pilot dataset. 
Must be supplied if dataset is set to NULL and variance 
components are supplied.}

\item{method}{"OR" (the default) or "DBM" (but see \code{LegacyCode} option
below).}

\item{analysisOption}{Desired generalization, "RRRC" (the default), "FRRC", 
"RRFC" or "ALL". RRFC = random reader fixed case, etc.}

\item{LegacyCode}{Logical, defaults to \code{FALSE}, which results in OR 
sample size method being used, even if DBM method is specified, as in 
Hillis 2011 & 2018 papers. If \code{TRUE} the method based on 
Hillis-Berbaum 2004 sample size paper is used.}

\item{alpha}{The significance level, default is 0.05.}
}
\value{
The expected statistical power.
}
\description{
Calculate the statistical power for specified numbers of readers J, 
   cases K, analysis method and DBM or OR variances components
}
\details{
The default \code{effectSize} uses the observed effect size in the 
   pilot study. A numeric value over-rides the default value. This argument 
   must be supplied if dataset = NULL and variance compenents 
   (the ... arguments) are supplied.
}
\note{
The procedure is valid for ROC studies only; for FROC studies see 
  Vignettes 19.
}
\examples{
## EXAMPLE 1: RRRC power 
## specify 2-treatment ROC dataset and force DBM alg.
SsPowerGivenJK(dataset = dataset02, FOM = "Wilcoxon", effectSize = 0.05, 
J = 6, K = 251, method = "DBM", LegacyCode = TRUE) # RRRC is default  

## EXAMPLE 1A: FRRC power 
SsPowerGivenJK(dataset = dataset02, FOM = "Wilcoxon", effectSize = 0.05, 
J = 6, K = 251, method = "DBM", LegacyCode = TRUE, analysisOption = "FRRC") 

## EXAMPLE 1B: RRFC power 
SsPowerGivenJK(dataset = dataset02, FOM = "Wilcoxon", effectSize = 0.05, 
J = 6, K = 251, method = "DBM", LegacyCode = TRUE, analysisOption = "RRFC") 

## EXAMPLE 2: specify NULL dataset & DBM var. comp. & force DBM-based alg.
vcDBM <- UtilVarComponentsDBM(dataset02, FOM = "Wilcoxon")$VarCom
SsPowerGivenJK(dataset = NULL, FOM = "Wilcoxon", J = 6, K = 251, 
effectSize = 0.05, method = "DBM", LegacyCode = TRUE, 
list( 
VarTR = vcDBM["VarTR","Estimates"], # replace rhs with actual values as in 4A
VarTC = vcDBM["VarTC","Estimates"], # do:
VarErr = vcDBM["VarErr","Estimates"])) # do:
                     
## EXAMPLE 3: specify 2-treatment ROC dataset and use OR-based alg.
SsPowerGivenJK(dataset = dataset02, FOM = "Wilcoxon", effectSize = 0.05, 
J = 6, K = 251)

## EXAMPLE 4: specify NULL dataset & OR var. comp. & use OR-based alg.
JStar <- length(dataset02$ratings$NL[1,,1,1])
KStar <- length(dataset02$ratings$NL[1,1,,1])
vcOR <- UtilORVarComponentsFactorial(dataset02, FOM = "Wilcoxon")$VarCom
SsPowerGivenJK(dataset = NULL, FOM = "Wilcoxon", effectSize = 0.05, J = 6, 
K = 251, list(JStar = JStar, KStar = KStar, 
   VarTR = vcOR["VarTR","Estimates"], # replace rhs with actual values as in 4A
   Cov1 = vcOR["Cov1","Estimates"],   # do:
   Cov2 = vcOR["Cov2","Estimates"],   # do:
   Cov3 = vcOR["Cov3","Estimates"],   # do:
   Var = vcOR["Var","Estimates"]))
   
## EXAMPLE 4A: specify NULL dataset & OR var. comp. & use OR-based alg.
SsPowerGivenJK(dataset = NULL, FOM = "Wilcoxon", effectSize = 0.05, J = 6, 
K = 251, list(JStar = 5, KStar = 114, 
   VarTR = 0.00020040252,
   Cov1 = 0.00034661371,
   Cov2 = 0.00034407483,
   Cov3 = 0.00023902837,
   Var = 0.00080228827))
   
## EXAMPLE 5: specify NULL dataset & DBM var. comp. & use OR-based alg.
## The DBM var. comp. are converted internally to OR var. comp.
vcDBM <- UtilVarComponentsDBM(dataset02, FOM = "Wilcoxon")$VarCom
KStar <- length(dataset02$ratings$NL[1,1,,1])
SsPowerGivenJK(dataset = NULL, J = 6, K = 251, effectSize = 0.05, 
method = "DBM", FOM = "Wilcoxon",
list(KStar = KStar,                # replace rhs with actual values as in 5A 
VarR = vcDBM["VarR","Estimates"], # do:
VarC = vcDBM["VarC","Estimates"], # do:
VarTR = vcDBM["VarTR","Estimates"], # do:
VarTC = vcDBM["VarTC","Estimates"], # do:
VarRC = vcDBM["VarRC","Estimates"], # do:
VarErr = vcDBM["VarErr","Estimates"]))

## EXAMPLE 5A: specify NULL dataset & DBM var. comp. & use OR-based alg.
SsPowerGivenJK(dataset = NULL, J = 6, K = 251, effectSize = 0.05, 
method = "DBM", FOM = "Wilcoxon",
list(KStar = 114,
VarR = 0.00153499935,
VarC = 0.02724923428,
VarTR = 0.00020040252,
VarTC = 0.01197529621,
VarRC = 0.01226472859,
VarErr = 0.03997160319))


}
\references{
Hillis SL, Berbaum KS (2004). Power Estimation for the Dorfman-Berbaum-Metz Method. 
   Acad Radiol, 11, 1260--1273.

Hillis SL, Obuchowski NA, Berbaum KS (2011). Power Estimation for Multireader ROC Methods: 
An Updated and Unified Approach. Acad Radiol, 18, 129--142.

Hillis SL, Schartz KM (2018). Multireader sample size program for 
   diagnostic studies: demonstration and methodology. Journal of 
   Medical Imaging, 5(04).
}
