% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateFrocFromLrocDataset.R
\name{SimulateFrocFromLrocDataset}
\alias{SimulateFrocFromLrocDataset}
\title{Simulates an "AUC-equivalent" FROC dataset from an LROC dataset}
\usage{
SimulateFrocFromLrocDataset(dataset)
}
\arguments{
\item{dataset}{The LROC dataset to be converted to FROC.}
}
\value{
The equivalent FROC dataset
}
\description{
Simulates a multiple-treatment multiple-reader 
   "AUC-equivalent" FROC dataset from a supplied LROC dataset,
   e.g., \link{datasetCadLroc}.
}
\details{
The LROC paradigm always yields a single mark per case. Therefore 
   the equivalent FROC will also have only one mark per case. The NL arrays 
   of the two datasets are identical. The LL array is created by copying the
   LLCl array of the LROC dataset to the LL array of the FROC dataset, from 
   diseased case index k2 = 1 to k2 = K2. Additionally, the LLIl array of the 
   LROC dataset is copied to the NL array of the FROC dataset, starting at case 
   index k1 = K1+1 to k1 = K1+K2. Any zero ratings are replace by -Infs. The 
   equivalent FROC dataset has the same HrAuc as the original LROC dataset. 
   See example. The main use of this function is to test the CAD significance
   testing functions using CAD FROC datasets, which I currently don't have.
}
\examples{

frocDataset <- SimulateFrocFromLrocDataset(datasetCadLroc)
lrocAuc <- UtilFigureOfMerit(datasetCadLroc, FOM = "Wilcoxon")
frocHrAuc <- UtilFigureOfMerit(frocDataset, FOM = "HrAuc")   

}
