% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateFrocDataset.R
\name{SimulateFrocDataset}
\alias{SimulateFrocDataset}
\title{Simulates an MRMC uncorrelated FROC dataset using the RSM}
\usage{
SimulateFrocDataset(mu, lambda, nu, zeta1, I, J, K1, K2, perCase, seed = NULL)
}
\arguments{
\item{mu}{The mu parameter of the RSM}

\item{lambda}{The intrinsic lambda parameter of the RSM (not the physical parameter)}

\item{nu}{The intrinsic nu parameter of the RSM (not the physical parameter)}

\item{zeta1}{The lowest reporting threshold}

\item{I}{The number of treatments}

\item{J}{The number of readers}

\item{K1}{The number of non-diseased cases}

\item{K2}{The number of diseased cases}

\item{perCase}{A K2 length array containing the numbers of lesions per diseased case}

\item{seed}{The initial seed for the random number generator, the default 
is \code{NULL}, as if no seed has been specified.}
}
\value{
The return value is an FROC dataset.
}
\description{
Simulates an uncorrelated MRMC FROC dataset for specified numbers of
   readers and treatments
}
\details{
See book chapters on the Radiological Search Model (RSM) for details. 
   In this code correlations between ratings on the same case are assumed to be zero.
}
\examples{
set.seed(1) 
K1 <- 5;K2 <- 7;
maxLL <- 2;perCase <- floor(runif(K2, 1, maxLL + 1))
mu <- 1;lambda <- 1;nu <- 1 ;zeta1 <- -1
I <- 2; J <- 5

frocDataRaw <- SimulateFrocDataset(
  mu = mu, lambda = lambda, nu = nu, zeta1 = zeta1,
  I = I, J = J, K1 = K1, K2 = K2, perCase = perCase )
  
## plot the data
ret <- PlotEmpiricalOperatingCharacteristics(frocDataRaw, opChType = "FROC")
## print(ret$Plot)

}
\references{
Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL.
}
