% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PowerTable.R
\name{PowerTable}
\alias{PowerTable}
\title{Calculate power table, different combinations, of J and K for desired power for ROC studies.}
\usage{
PowerTable(dataset, alpha = 0.05, effectSize = 0.05, desiredPower = 0.8,
  randomOption = "ALL")
}
\arguments{
\item{dataset}{The dataset to be analyzed, see \link{RJafroc-package}.}

\item{alpha}{The significantce level.}

\item{effectSize}{The effect size to be used in the calculation.}

\item{desiredPower}{The desired statistical power.}

\item{randomOption}{The random option. It can be \code{ALL}, \code{READERS} or \code{CASES}, which indicate predictions for (1) random readers and random cases, (2) random readers only and
(3) random cases only.}
}
\value{
The return is a data frame containing following three columns.

\item{numReaders}{The number of readers.}

\item{numCases}{The number of cases.}

\item{power}{The statistical power for the number of readers and cases combination.}
}
\description{
Calculate required sample size for the specified dataset with given significance level, effect size and desired power
}
\examples{
retDbm <- DBMHAnalysis(data = rocData, fom = "Wilcoxon")
effectSize <- retDbm$ciDiffTrtRRRC$Estimate
PowerTable(dataset = rocData, effectSize = effectSize)
}

