/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.DSDIdentifier;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.client.custom.RestSdmx20Client;
import it.bancaditalia.oss.sdmx.parser.v20.DataStructureParser;
import it.bancaditalia.oss.sdmx.parser.v21.RestQueryBuilder;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class INEGI
extends RestSdmx20Client {
    protected static Logger logger = Configuration.getSdmxLogger();

    public INEGI() throws MalformedURLException {
        super("INEGI", new URL("http://www.snieg.mx/opendata/NSIRestService"), false, null, null);
    }

    @Override
    protected String buildCodelistQuery(String string, String string2, String string3) throws SdmxException {
        if (this.endpoint != null && string != null && !string.isEmpty()) {
            String string4 = this.endpoint + "/Codelist/" + "ALL/" + string + "/ALL";
            return string4;
        }
        throw new SdmxException("Invalid query parameters: codeList=" + string + " endpoint=" + this.endpoint);
    }

    @Override
    protected String buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        if (this.endpoint != null) {
            string2 = string2 == null || string2.equals("all") ? "ALL" : string2;
            string3 = "ALL";
            String string4 = string2 + "/" + string + "/" + string3;
            String string5 = this.endpoint + "/Dataflow";
            if (string4 == null || string4.isEmpty()) {
                throw new SdmxException("Invalid query parameters: dataflow=" + string4);
            }
            string5 = string5 + "/" + string4;
            return string5;
        }
        throw new RuntimeException("Invalid query parameters: endpoint=" + this.endpoint);
    }

    @Override
    protected String buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        string3 = "ALL";
        if (this.endpoint != null && string != null && !string.isEmpty()) {
            String string4 = this.endpoint + "/DataStructure/" + string2 + "/" + string + "/" + string3;
            if (bl) {
                string4 = string4 + "?references=children";
            }
            return string4;
        }
        throw new RuntimeException("Invalid query parameters: dsd=" + string + " endpoint=" + this.endpoint);
    }

    @Override
    public DataFlowStructure getDataFlowStructure(DSDIdentifier dSDIdentifier, boolean bl) throws SdmxException {
        String string = null;
        InputStreamReader inputStreamReader = null;
        DataFlowStructure dataFlowStructure = new DataFlowStructure();
        if (dSDIdentifier != null) {
            string = this.buildDSDQuery(dSDIdentifier.getId(), dSDIdentifier.getAgency(), dSDIdentifier.getVersion(), bl);
            inputStreamReader = this.runQuery(string, null);
            if (inputStreamReader != null) {
                try {
                    dataFlowStructure = DataStructureParser.parse(inputStreamReader).get(0);
                }
                catch (Exception exception) {
                    logger.severe("Exception caught parsing results from call to provider " + this.name);
                    logger.log(Level.FINER, "Exception: ", exception);
                    throw new SdmxException("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                }
                finally {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {
                        logger.severe("Exception caught closing stream.");
                    }
                }
            }
            throw new SdmxException("The query returned a null stream");
        }
        throw new SdmxException("Null dsd in input");
        return dataFlowStructure;
    }

    @Override
    protected String buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) {
        if (this.endpoint != null && dataflow != null && string != null && !string.isEmpty()) {
            String string5 = this.endpoint + "/Data/ALL," + dataflow.getId() + ",ALL/";
            string5 = string5 + string + "/" + this.name + "/";
            string5 = string5 + RestQueryBuilder.addParams(string2, string3, bl, null, false, this.format);
            return string5;
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.endpoint);
    }
}

