/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.sa;

import ec.satoolkit.algorithm.implementation.TramoSeatsProcessingFactory;
import ec.satoolkit.algorithm.implementation.X13ProcessingFactory;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.satoolkit.x13.X13Specification;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.jdr.sa.TramoSeatsResults;
import ec.tstoolkit.jdr.sa.X13Results;
import ec.tstoolkit.timeseries.simplets.TsData;
import jdr.spec.ts.Utility;
import lombok.Generated;

public final class Processor {
    private static final double E_LIMIT1 = 0.01;
    private static final double E_LIMIT2 = 0.005;
    static final int NY = 8;

    public static TramoSeatsResults tramoseats(TsData s, TramoSeatsSpecification spec, Utility.Dictionary dic) {
        ProcessingContext context = null;
        if (dic != null) {
            context = dic.toContext();
        }
        return Processor.tramoseatsWithContext(s, spec, context);
    }

    public static TramoSeatsResults tramoseatsWithContext(TsData s, TramoSeatsSpecification spec, ProcessingContext context) {
        s = s.cleanExtremities();
        CompositeResults rslts = TramoSeatsProcessingFactory.process((TsData)s, (TramoSeatsSpecification)spec, (ProcessingContext)context);
        return new TramoSeatsResults(rslts);
    }

    public static X13Results x13(TsData s, X13Specification spec, Utility.Dictionary dic) {
        ProcessingContext context = null;
        if (dic != null) {
            context = dic.toContext();
        }
        return Processor.x13WithContext(s, spec, context);
    }

    public static X13Results x13WithContext(TsData s, X13Specification spec, ProcessingContext context) {
        s = s.cleanExtremities();
        CompositeResults rslts = X13ProcessingFactory.process((TsData)s, (X13Specification)spec, (ProcessingContext)context);
        return new X13Results(rslts);
    }

    @Generated
    private Processor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

