/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.arima;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.SsfException;

public abstract class SsfBaseArima
implements ISsf {
    IArimaModel m_model;
    int m_dim;
    double[] m_phi;
    double[] m_psi;
    double[] m_tmp;
    DataBlock m_Phi;

    public SsfBaseArima() {
    }

    public SsfBaseArima(IArimaModel arima) {
        this.m_model = arima;
    }

    @Override
    public abstract void diffuseConstraints(SubMatrix var1);

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        this.fullQ(qm);
    }

    public void fullQ(SubMatrix qm) {
        double v = this.m_model.getInnovationVariance();
        for (int i = 0; i < this.m_dim; ++i) {
            for (int j = 0; j <= i; ++j) {
                qm.set(i, j, this.m_psi[i] * this.m_psi[j] * v);
            }
        }
        SymmetricMatrix.fromLower(qm);
    }

    public IArimaModel getModel() {
        return this.m_model;
    }

    @Override
    public abstract int getNonStationaryDim();

    @Override
    public int getStateDim() {
        return this.m_dim;
    }

    @Override
    public int getTransitionResCount() {
        return this.m_dim;
    }

    @Override
    public int getTransitionResDim() {
        return 1;
    }

    public double H(int pos) {
        return 0.0;
    }

    public boolean hasH() {
        return false;
    }

    @Override
    public boolean hasR() {
        return false;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return true;
    }

    protected abstract void initModel();

    @Override
    public abstract boolean isDiffuse();

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.m_model != null;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        this.T(lm);
        DataBlock col = lm.column(0);
        col.sub(k);
    }

    @Override
    public abstract void Pf0(SubMatrix var1);

    @Override
    public abstract void Pi0(SubMatrix var1);

    @Override
    public void Q(int pos, SubMatrix qm) {
        this.Q(qm);
    }

    public void Q(SubMatrix qm) {
        qm.set(0, 0, this.m_model.getInnovationVariance());
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
    }

    public void setModel(IArimaModel value) {
        if (!value.isStationary()) {
            throw new SsfException("Non stationary model", "Arima ssf", 0);
        }
        this.m_model = value;
        this.initModel();
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        this.T(tr);
    }

    public void T(SubMatrix tr) {
        int i;
        tr.set(0.0);
        for (i = 1; i < this.m_dim; ++i) {
            tr.set(i - 1, i, 1.0);
        }
        for (i = 1; i < this.m_phi.length; ++i) {
            tr.set(this.m_dim - 1, this.m_dim - i, -this.m_phi[i]);
        }
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        DataBlock tmp = new DataBlock(this.m_tmp);
        tmp.set(0.0);
        DataBlockIterator cols = vm.columns();
        DataBlock col = cols.getData();
        cols.end();
        for (int p = 1; p < this.m_phi.length; ++p) {
            tmp.addAY(-this.m_phi[p], col);
            cols.previous();
        }
        double tlast = -this.m_Phi.dotReverse(tmp);
        vm.shift(-1);
        tmp.bshift(DataBlock.ShiftOption.None);
        this.m_tmp[this.m_dim - 1] = tlast;
        vm.column(this.m_dim - 1).copy(tmp);
        vm.row(this.m_dim - 1).copy(tmp);
    }

    public void TX(DataBlock x) {
        double last = this.m_Phi.dot(x.reverse());
        x.bshift(DataBlock.ShiftOption.None);
        x.set(this.m_dim - 1, -last);
    }

    @Override
    public void TX(int pos, DataBlock x) {
        double last = this.m_Phi.dotReverse(x);
        x.bshift(DataBlock.ShiftOption.None);
        x.set(this.m_dim - 1, -last);
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        vm.add(0, 0, d);
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        DataBlock tmp = new DataBlock(this.m_psi);
        wv.column(0).copy(tmp);
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        x.add(0, d);
    }

    @Override
    public void XT(int pos, DataBlock x) {
        double last = -x.get(this.m_dim - 1);
        x.fshift(DataBlock.ShiftOption.None);
        x.set(0, 0.0);
        if (last != 0.0) {
            for (int i = 1; i < this.m_phi.length; ++i) {
                if (this.m_phi[i] == 0.0) continue;
                x.add(this.m_dim - i, last * this.m_phi[i]);
            }
        }
    }

    @Override
    public void Z(int pos, DataBlock x) {
        x.set(0, 1.0);
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        x.copy(m.row(0));
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        return vm.get(0, 0);
    }

    public double ZX(DataBlock x) {
        return x.get(0);
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        return x.get(0);
    }

    public double ZX(int pos, double[] vX) {
        return vX[0];
    }
}

