/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

class Support {
    private Support() {
    }

    static double sign(double a, double b) {
        return b >= 0.0 ? (a >= 0.0 ? a : -a) : (a >= 0.0 ? -a : a);
    }

    public static double pythagoras(double a, double b) {
        double bb;
        double aa = Math.abs(a);
        if (aa > (bb = Math.abs(b))) {
            double aa_bb = bb / aa;
            return aa * Math.sqrt(1.0 + aa_bb * aa_bb);
        }
        double bb_aa = aa / bb;
        return bb == 0.0 ? 0.0 : bb * Math.sqrt(1.0 + bb_aa * bb_aa);
    }
}

