/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.DefaultSeasonalFilteringStrategy;
import ec.satoolkit.x11.IEndPointsProcessor;
import ec.satoolkit.x11.IFiltering;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.timeseries.simplets.PeriodIterator;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class ComplexSeasonalFilteringStrategy
implements IFiltering {
    private SymmetricFilter[] filters;
    private IEndPointsProcessor[] endPointsProcessors;

    @Override
    public String getDescription() {
        return "Composite filter";
    }

    public ComplexSeasonalFilteringStrategy(DefaultSeasonalFilteringStrategy[] options) {
        this.filters = new SymmetricFilter[options.length];
        this.endPointsProcessors = new IEndPointsProcessor[options.length];
        for (int i = 0; i < options.length; ++i) {
            if (options[i] == null) continue;
            this.filters[i] = options[i].filter;
            this.endPointsProcessors[i] = options[i].endPointsProcessor;
        }
    }

    public ComplexSeasonalFilteringStrategy(SymmetricFilter[] filters, IEndPointsProcessor[] endPoints) {
        this.filters = filters;
        this.endPointsProcessors = endPoints;
    }

    @Override
    public SymmetricFilter getCentralFilter() {
        return null;
    }

    @Override
    public TsData process(TsData s, TsDomain domain) {
        TsDomain rdomain = domain == null ? s.getDomain() : domain;
        int ny_all = rdomain.getLength() / rdomain.getFrequency().intValue();
        int nyr_all = rdomain.getLength() % rdomain.getFrequency().intValue() == 0 ? ny_all : ny_all + 1;
        TsData out = new TsData(rdomain);
        PeriodIterator pin = new PeriodIterator(s, domain);
        PeriodIterator pout = new PeriodIterator(out);
        int p = 0;
        while (pin.hasMoreElements()) {
            DataBlock bin = pin.nextElement().data;
            DataBlock bout = pout.nextElement().data;
            int nf = 0;
            if (this.filters[p] != null) {
                nf = this.filters[p].getUpperBound();
            }
            if (this.filters[p] != null && ny_all >= 5 && (nf < 8 || nyr_all >= 20)) {
                this.filters[p].filter(bin, bout.drop(nf, nf));
                this.endPointsProcessors[p].process(bin, bout);
            } else {
                bout.set(bin.average());
            }
            ++p;
        }
        return out;
    }
}

