/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.arima;

import ec.tstoolkit.arima.AutoCovarianceFunction;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.RationalFunction;
import ec.tstoolkit.ssf.FastArrayState;
import ec.tstoolkit.ssf.FastState;
import ec.tstoolkit.ssf.IFastArrayFilteringResults;
import ec.tstoolkit.ssf.IFastArrayInitializer;
import ec.tstoolkit.ssf.IFastFilteringResults;
import ec.tstoolkit.ssf.IFastInitializer;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.SsfException;
import ec.tstoolkit.ssf.arima.SsfBaseArima;

public final class SsfArma
extends SsfBaseArima {
    double[] m_acgf;

    public SsfArma() {
    }

    public SsfArma(IArimaModel arima) {
        this.m_model = arima;
        this.initModel();
    }

    @Override
    public void diffuseConstraints(SubMatrix pm) {
    }

    @Override
    public int getNonStationaryDim() {
        return 0;
    }

    @Override
    protected void initModel() {
        if (!this.m_model.isStationary()) {
            throw new SsfException("Non stationary model");
        }
        double var = this.m_model.getInnovationVariance();
        if (var == 0.0) {
            throw new SsfException("Invalid stochastic model");
        }
        Polynomial phi = this.m_model.getAR().getPolynomial();
        this.m_phi = phi.getCoefficients();
        this.m_Phi = new DataBlock(this.m_phi, 1, this.m_phi.length, 1);
        Polynomial theta = this.m_model.getMA().getPolynomial();
        this.m_dim = Math.max(phi.getDegree(), theta.getDegree() + 1);
        this.m_psi = new RationalFunction(theta, phi).coefficients(this.m_dim);
        this.m_acgf = new AutoCovarianceFunction(theta, phi, var).values(this.m_dim);
        this.m_tmp = new double[this.m_dim];
    }

    @Override
    public boolean isDiffuse() {
        return false;
    }

    @Override
    public void Pf0(SubMatrix pm) {
        for (int j = 0; j < this.m_dim; ++j) {
            pm.set(j, 0, this.m_acgf[j]);
        }
        double v = this.m_model.getInnovationVariance();
        for (int j = 0; j < this.m_dim - 1; ++j) {
            pm.set(j + 1, j + 1, pm.get(j, j) - this.m_psi[j] * this.m_psi[j] * v);
            for (int k = 0; k < j; ++k) {
                pm.set(j + 1, k + 1, pm.get(j, k) - this.m_psi[j] * this.m_psi[k] * v);
            }
        }
        SymmetricMatrix.fromLower(pm);
    }

    @Override
    public void Pi0(SubMatrix pm) {
    }

    public static class FastInitializer
    implements IFastInitializer<SsfArma>,
    IFastArrayInitializer<SsfArma> {
        @Override
        public int initialize(SsfArma ssf, ISsfData data, FastArrayState state, IFastArrayFilteringResults rslts) {
            double r0 = Math.sqrt(ssf.m_acgf[0]);
            DataBlock k0 = new DataBlock((double[])ssf.m_acgf.clone());
            ssf.TX(k0);
            double[] a = data.getInitialState();
            if (a != null) {
                state.A.copyFrom(a, 0);
            }
            state.r = r0;
            k0.mul(1.0 / r0);
            state.K.copy(k0);
            state.L.copy(k0);
            return 0;
        }

        @Override
        public int initialize(SsfArma ssf, ISsfData data, FastState state, IFastFilteringResults rslts) {
            double v0 = ssf.m_acgf[0];
            DataBlock k0 = new DataBlock((double[])ssf.m_acgf.clone());
            ssf.TX(k0);
            double[] a = data.getInitialState();
            if (a != null) {
                state.A.copyFrom(a, 0);
            }
            state.f = v0;
            state.C.copy(k0);
            state.L.copy(k0);
            return 0;
        }
    }
}

