/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Supplier;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import jd2.workspace.file.FileSupport;
import jd2.workspace.io.JaxbUtil;
import jd2.workspace.util.Paths;
import jd2.xml.IXmlConverter;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class XmlConverterSupport
implements FileSupport {
    private final String repository;
    private final Supplier<? extends IXmlConverter> factory;
    private final Class<? extends IXmlConverter> type;

    public static @NonNull FileSupport of(@NonNull Supplier<? extends IXmlConverter> factory, @NonNull String repository) {
        return new XmlConverterSupport(factory, repository);
    }

    private XmlConverterSupport(Supplier<? extends IXmlConverter> factory, String repository) {
        this.repository = Objects.requireNonNull(repository);
        this.factory = Objects.requireNonNull(factory);
        this.type = factory.get().getClass();
    }

    @Override
    public Path resolveFile(Path root, String fileName) {
        return root.resolve(this.repository).resolve(XmlConverterSupport.xmlFileName(fileName));
    }

    @Override
    public Object read(Path root, String fileName) throws IOException {
        try {
            return XmlConverterSupport.readItem(this.resolveFile(root, fileName), this.type);
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void write(Path root, String fileName, Object value) throws IOException {
        try {
            XmlConverterSupport.writeItem(this.resolveFile(root, fileName), this.factory, value);
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }

    static Object readItem(Path file, Class<? extends IXmlConverter> type) throws IOException, JAXBException {
        return XmlConverterSupport.xmlToItem(XmlConverterSupport.unmarshalItem(file, type));
    }

    static void writeItem(Path file, Supplier<? extends IXmlConverter> factory, Object value) throws IOException, JAXBException {
        XmlConverterSupport.marshalItem(file, XmlConverterSupport.itemToXml(factory, value));
    }

    private static String xmlFileName(String fileName) {
        return Paths.changeExtension(fileName, "xml");
    }

    private static Object xmlToItem(IXmlConverter xml) throws IOException {
        Object result = xml.create();
        if (result == null) {
            throw new IOException("Cannot create item using " + xml.getClass());
        }
        return result;
    }

    private static IXmlConverter itemToXml(Supplier<? extends IXmlConverter> factory, Object value) throws IOException {
        IXmlConverter result = factory.get();
        result.copy(value);
        return result;
    }

    private static <X extends IXmlConverter<?>> X unmarshalItem(Path file, Class<X> type) throws JAXBException, IOException {
        return (X)((IXmlConverter)JaxbUtil.unmarshal(file, JAXBContext.newInstance((Class[])new Class[]{type})));
    }

    private static void marshalItem(Path file, IXmlConverter<?> jaxbElement) throws JAXBException, IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        JaxbUtil.marshal(file, JAXBContext.newInstance((Class[])new Class[]{jaxbElement.getClass()}), jaxbElement, true);
    }
}

