/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.utilities;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;

public final class Arrays2 {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];

    public static void copy(double[] sourceArray, double[] destinationArray, int length) {
        System.arraycopy(sourceArray, 0, destinationArray, 0, length);
    }

    public static void reverse(double[] array) {
        Arrays2.reverse(array, 0, array.length);
    }

    public static void reverse(double[] array, int start, int n) {
        int i = start;
        int j = start + n - 1;
        while (i < j) {
            Arrays2.swap(array, i++, j--);
        }
    }

    public static void reverse(int[] array) {
        Arrays2.reverse(array, 0, array.length);
    }

    public static void reverse(int[] array, int start, int n) {
        int i = start;
        int j = start + n - 1;
        while (i < j) {
            Arrays2.swap(array, i++, j--);
        }
    }

    public static void reverse(Object[] array) {
        Arrays2.reverse(array, 0, array.length);
    }

    public static void reverse(Object[] array, int start, int n) {
        int i = start;
        int j = start + n - 1;
        while (i < j) {
            Arrays2.swap(array, i++, j--);
        }
    }

    public static void swap(double[] array, int a, int b) {
        double t = array[a];
        array[a] = array[b];
        array[b] = t;
    }

    public static void swap(int[] array, int a, int b) {
        int t = array[a];
        array[a] = array[b];
        array[b] = t;
    }

    public static void swap(Object[] array, int a, int b) {
        Object t = array[a];
        array[a] = array[b];
        array[b] = t;
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T[] copyOf(T[] original) {
        return Arrays.copyOf(original, original.length);
    }

    public static <T> T[] concat(T[] first, T[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static double[] concat(double[] ... arrays) {
        int totalLength = 0;
        for (double[] o : arrays) {
            totalLength += o.length;
        }
        double[] result = new double[totalLength];
        int destPos = 0;
        for (double[] o : arrays) {
            System.arraycopy(o, 0, result, destPos, o.length);
            destPos += o.length;
        }
        return result;
    }

    public static double[] compact(double[] array) {
        int nm = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!Double.isNaN(array[i])) continue;
            ++nm;
        }
        if (nm == 0) {
            return array;
        }
        double[] narray = new double[array.length - nm];
        int j = 0;
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i])) continue;
            narray[j++] = array[i];
        }
        return narray;
    }

    public static void shift(double[] array, int shiftsize) {
        Arrays2.shift(array, shiftsize, 0, array.length);
    }

    public static void shift(double[] array, int shiftsize, int fromIndex, int toIndex) {
        if (shiftsize > 0) {
            System.arraycopy(array, fromIndex, array, fromIndex + shiftsize, toIndex - fromIndex - shiftsize);
        } else {
            System.arraycopy(array, fromIndex - shiftsize, array, fromIndex, toIndex - fromIndex + shiftsize);
        }
    }

    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static <T> boolean arrayEquals(T oldValue, T newValue) {
        if (Arrays2.isArray(oldValue) && Arrays2.isArray(newValue) && oldValue.getClass().getComponentType().equals(newValue.getClass().getComponentType())) {
            Class<?> type = oldValue.getClass().getComponentType();
            if (type.equals(Long.TYPE)) {
                return Arrays.equals((long[])oldValue, (long[])newValue);
            }
            if (type.equals(Integer.TYPE)) {
                return Arrays.equals((int[])oldValue, (int[])newValue);
            }
            if (type.equals(Short.TYPE)) {
                return Arrays.equals((short[])oldValue, (short[])newValue);
            }
            if (type.equals(Character.TYPE)) {
                return Arrays.equals((char[])oldValue, (char[])newValue);
            }
            if (type.equals(Byte.TYPE)) {
                return Arrays.equals((byte[])oldValue, (byte[])newValue);
            }
            if (type.equals(Boolean.TYPE)) {
                return Arrays.equals((boolean[])oldValue, (boolean[])newValue);
            }
            if (type.equals(Double.TYPE)) {
                return Arrays.equals((double[])oldValue, (double[])newValue);
            }
            if (type.equals(Float.TYPE)) {
                return Arrays.equals((float[])oldValue, (float[])newValue);
            }
            return Arrays.equals((Object[])oldValue, (Object[])newValue);
        }
        return false;
    }

    public static <T> List<T> unmodifiableList(T ... array) {
        return new UnmodifiableList<T>(array);
    }

    private Arrays2() {
    }

    private static class UnmodifiableList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = -2764017481108945198L;
        private final E[] a;

        UnmodifiableList(E[] array) {
            this.a = Objects.requireNonNull(array);
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                return Arrays.copyOf(this.a, size, a.getClass());
            }
            System.arraycopy(this.a, 0, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public E get(int index) {
            return this.a[index];
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                for (int i = 0; i < this.a.length; ++i) {
                    if (this.a[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.a.length; ++i) {
                    if (!o.equals(this.a[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }
    }
}

