/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.ISeriesDecomposer;
import ec.satoolkit.seats.DefaultModelDecomposer;
import ec.satoolkit.seats.IArimaDecomposer;
import ec.satoolkit.seats.IModelApproximator;
import ec.satoolkit.seats.IModelValidator;
import ec.satoolkit.seats.ISeatsToolkit;
import ec.satoolkit.seats.ModelStatus;
import ec.satoolkit.seats.SeatsContext;
import ec.satoolkit.seats.SeatsException;
import ec.satoolkit.seats.SeatsModel;
import ec.satoolkit.seats.SeatsResults;
import ec.satoolkit.seats.SeatsSpecification;
import ec.satoolkit.seats.SeatsToolkit;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.ucarima.UcarimaModel;

public class SeatsKernel
implements ISeriesDecomposer {
    public static final String COMPONENTS = "components";
    public static final String DECOMPOSITION = "decomposition";
    private ISeatsToolkit toolkit;
    private final String NON_DECOMPOSABLE = "Non decomposable model";
    private final String CUT_OFF = "Parameters cut off";

    public ISeatsToolkit getToolkit() {
        return this.toolkit;
    }

    @Override
    public SeatsResults process(TsData s) {
        InformationSet info = new InformationSet();
        if (this.toolkit == null) {
            this.toolkit = SeatsToolkit.create(new SeatsSpecification());
        }
        SeatsContext context = this.toolkit.getContext();
        context.check(s);
        SeatsModel model = this.toolkit.getModelBuilder().build(s, info, context);
        this.validate(model, info, context);
        IModelApproximator approximator = this.toolkit.getModelApproximator();
        approximator.pretest(model, info, context);
        approximator.startApproximation();
        IArimaDecomposer decomposer = this.toolkit.getModelDecomposer();
        UcarimaModel ucm = null;
        int nround = 0;
        while (++nround <= 10) {
            ucm = decomposer.decompose(model, info, context);
            if (ucm == null && nround == 1) {
                this.addWarning("Non decomposable model", model, context);
            }
            if (ucm != null || context.getApproximationMode() == SeatsSpecification.ApproximationMode.None || !approximator.approximate(model, info, context)) break;
            model.setChanged(true);
        }
        if (ucm == null) {
            throw new SeatsException("Invalid decomposition");
        }
        SeatsResults results = new SeatsResults();
        results.model = model;
        results.decomposition = ucm;
        results.initialComponents = this.toolkit.getComponentsEstimator().decompose(model, ucm, info, context);
        results.finalComponents = this.toolkit.getBiasCorrector().correct(results.initialComponents, info, context);
        results.info_ = info;
        results.addProcessingInformation(context.processingLog);
        return results;
    }

    public void setToolkit(ISeatsToolkit toolkit) {
        this.toolkit = toolkit;
    }

    private void validate(SeatsModel model, InformationSet info, SeatsContext context) {
        IModelValidator validator = this.toolkit.getModelValidator();
        ModelStatus status = validator.validate(model.getSarima(), info);
        if (status == ModelStatus.Invalid) {
            throw new SeatsException("Invalid model");
        }
        if (status == ModelStatus.Changed) {
            model.setModel(validator.getNewModel());
            model.setCutOff(true);
            info.addWarning("Model adjusted to boundaries");
            this.addWarning("Parameters cut off", model, context);
        }
    }

    private void addWarning(String msg, SeatsModel model, SeatsContext context) {
        if (context.processingLog != null) {
            context.processingLog.add(ProcessingInformation.warning("Model decomposition", DefaultModelDecomposer.class.getName(), msg, model.getSarima().clone()));
        }
    }
}

