/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.stats;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.dstats.IDistribution;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.stats.StatException;

public class StatisticalTest {
    protected IDistribution m_dist;
    protected double m_val;
    protected TestType m_type = TestType.Undefined;
    protected boolean m_asympt;
    protected boolean m_computed;
    private double m_significancethreshold = 0.01;

    protected StatisticalTest() {
    }

    public StatisticalTest(IDistribution dist, double val, TestType type, boolean asymptotical) {
        this.m_dist = dist;
        this.m_val = val;
        this.m_type = type;
        this.m_asympt = asymptotical;
    }

    protected void clear() {
        this.m_dist = null;
        this.m_val = 0.0;
        this.m_computed = false;
    }

    public IDistribution getDistribution() {
        return this.m_dist;
    }

    public double getPValue() {
        try {
            switch (this.m_type) {
                case TwoSided: {
                    if (!this.m_dist.isSymmetrical()) {
                        throw new StatException("misspecified test");
                    }
                    double mean = this.m_dist.getExpectation();
                    return 2.0 * this.m_dist.getProbability(this.m_val, this.m_val < mean ? ProbabilityType.Lower : ProbabilityType.Upper);
                }
                case Lower: {
                    return this.m_dist.getProbability(this.m_val, ProbabilityType.Lower);
                }
                case Upper: {
                    return this.m_dist.getProbability(this.m_val, ProbabilityType.Upper);
                }
            }
            return -1.0;
        }
        catch (BaseException e) {
            return Double.NaN;
        }
    }

    public double getSignificanceThreshold() {
        return this.m_significancethreshold;
    }

    public TestType getType() {
        return this.m_type;
    }

    public double getValue() {
        return this.m_val;
    }

    public boolean isAsymptotical() {
        return this.m_asympt;
    }

    public boolean isSignificant() {
        return this.getPValue() < this.m_significancethreshold;
    }

    public boolean isValid() {
        return true;
    }

    public void setSignificanceThreshold(double value) {
        this.m_significancethreshold = value;
    }
}

