/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.Likelihood;
import ec.tstoolkit.maths.matrices.Matrix;

public class ConcentratedLikelihood
extends Likelihood {
    private double[] m_b;
    private Matrix m_bvar;
    private int m_nx;

    public double[] getB() {
        return this.m_b;
    }

    public double getBSer(int idx, boolean unbiased, int hpcount) {
        if (unbiased) {
            double n = this.getN();
            double c = n / (n - (double)this.m_nx - (double)hpcount);
            return Math.sqrt(this.m_bvar.get(idx, idx) * c);
        }
        return Math.sqrt(this.m_bvar.get(idx, idx));
    }

    public double[] getBSer(boolean unbiased, int hpcount) {
        if (this.m_b == null) {
            return null;
        }
        double[] se = new double[this.m_b.length];
        double c = 1.0;
        if (unbiased) {
            double n = this.getN();
            c = n / (n - (double)this.m_nx - (double)hpcount);
        }
        for (int i = 0; i < se.length; ++i) {
            se[i] = Math.sqrt(this.m_bvar.get(i, i) * c);
        }
        return se;
    }

    public Matrix getBVar() {
        return this.m_bvar;
    }

    public Matrix getBVar(boolean unbiased, int hpcount) {
        if (unbiased && this.m_bvar != null) {
            double n = this.getN();
            double c = n / (n - (double)this.m_nx - (double)hpcount);
            return this.m_bvar.times(c);
        }
        return this.m_bvar;
    }

    public int getDegreesOfFreedom(boolean unbiased, int hpcount) {
        int n = this.getN();
        if (unbiased && (n -= this.m_nx + hpcount) <= 0) {
            n += hpcount;
        }
        return n;
    }

    public int getNx() {
        return this.m_nx;
    }

    public double[] getTStats() {
        return this.getTStats(false, 0);
    }

    public double[] getTStats(boolean unbiased, int hpcount) {
        if (this.m_bvar == null) {
            return null;
        }
        double c = 1.0;
        if (unbiased) {
            double n = this.getN();
            c = n / (n - (double)this.m_nx - (double)hpcount);
        }
        DataBlock diag = this.m_bvar.diagonal();
        double[] t = new double[diag.getLength()];
        for (int i = 0; i < t.length; ++i) {
            t[i] = this.m_b[i] == 0.0 ? 0.0 : this.m_b[i] / Math.sqrt(c * diag.get(i));
        }
        return t;
    }

    public double getTStat(int idx, boolean unbiased, int hpcount) {
        double e = this.m_bvar.get(idx, idx);
        if (e == 0.0) {
            return Double.NaN;
        }
        double b = this.m_b[idx];
        if (b == 0.0) {
            return 0.0;
        }
        if (unbiased) {
            double n = this.getN();
            return b / Math.sqrt(e * n / (n - (double)this.m_nx - (double)hpcount));
        }
        return b / Math.sqrt(e);
    }

    public void rescale(double yfactor, double[] xfactor) {
        super.rescale(yfactor);
        if (this.m_b == null || xfactor == null) {
            return;
        }
        for (int i = 0; i < this.m_b.length; ++i) {
            double ifactor = xfactor[i] / yfactor;
            int n = i;
            this.m_b[n] = this.m_b[n] * ifactor;
            for (int j = 0; j < i; ++j) {
                double ijfactor = ifactor * xfactor[j] / yfactor;
                this.m_bvar.mul(i, j, ijfactor);
                this.m_bvar.mul(j, i, ijfactor);
            }
            this.m_bvar.mul(i, i, ifactor * ifactor);
        }
    }

    public void setB(double[] b, Matrix bvar, int nx) {
        if (b != null) {
            this.m_b = (double[])b.clone();
            this.m_bvar = bvar.clone();
        } else {
            this.m_b = null;
            this.m_bvar = null;
        }
        this.m_nx = nx;
    }
}

