/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.dstats;

import ec.tstoolkit.dstats.BoundaryType;
import ec.tstoolkit.dstats.DStatException;
import ec.tstoolkit.dstats.IContinuousDistribution;
import ec.tstoolkit.dstats.IInterval;
import ec.tstoolkit.dstats.Interval;
import ec.tstoolkit.dstats.ProbabilityType;
import ec.tstoolkit.dstats.SpecialFunctions;
import ec.tstoolkit.dstats.Utility;
import ec.tstoolkit.random.IRandomNumberGenerator;
import ec.tstoolkit.random.StochasticRandomizer;
import java.util.Formatter;

public class Normal
implements IContinuousDistribution {
    private double mean_ = 0.0;
    private double stdev_ = 1.0;

    double evaluate(double x) {
        return this.getProbability(x, ProbabilityType.Lower);
    }

    public IInterval getConfidenceInterval(double p) {
        double r0;
        double r1 = this.getProbabilityInverse((1.0 - p) / 2.0, ProbabilityType.Upper);
        if (r1 < (r0 = 2.0 * this.mean_ - r1)) {
            double tmp = r0;
            r0 = r1;
            r1 = tmp;
        }
        Interval ni = new Interval(r0 * this.stdev_ + this.mean_, r1 * this.stdev_ + this.mean_);
        return ni;
    }

    @Override
    public double getDensity(double x) {
        return SpecialFunctions.normalDensity(x, this.mean_, this.stdev_);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Normal with Mean = ");
        sb.append(this.mean_);
        sb.append(" and Stdev = ");
        sb.append(this.stdev_);
        return sb.toString();
    }

    @Override
    public double getExpectation() {
        return this.mean_;
    }

    @Override
    public double getLeftBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getMean() {
        return this.mean_;
    }

    @Override
    public double getProbability(double x, ProbabilityType pt) {
        if (pt == ProbabilityType.Point) {
            return 0.0;
        }
        double zx = (x - this.mean_) / this.stdev_;
        return Utility.intProbability(zx, pt);
    }

    @Override
    public double getProbabilityInverse(double p, ProbabilityType pt) {
        if (pt == ProbabilityType.Point) {
            return Double.NaN;
        }
        if (pt == ProbabilityType.Upper) {
            p = 1.0 - p;
        }
        if (p < 1.0E-15 || 1.0 - p < 1.0E-15) {
            throw new DStatException("Can't compute probability inverse (value is too near 0 or 1)", "Normal");
        }
        Utility.calcProbDelegate cb = new Utility.calcProbDelegate(){

            @Override
            public double calcProb(double x) {
                return Normal.this.evaluate(x);
            }
        };
        double zp = Utility.intProbabilityInverse(p, cb);
        return zp * this.stdev_ + this.mean_;
    }

    @Override
    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    public IInterval getSignificanceInterval(double x) {
        double r0;
        double r1 = this.getProbabilityInverse(x / 2.0, ProbabilityType.Upper);
        if (r1 < (r0 = 2.0 * this.mean_ - r1)) {
            double tmp = r0;
            r0 = r1;
            r1 = tmp;
        }
        Interval ni = new Interval(r0 * this.stdev_ + this.mean_, r1 * this.stdev_ + this.mean_);
        return ni;
    }

    public double getStdev() {
        return this.stdev_;
    }

    @Override
    public double getVariance() {
        return this.stdev_ * this.stdev_;
    }

    @Override
    public BoundaryType hasLeftBound() {
        return BoundaryType.None;
    }

    @Override
    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    @Override
    public boolean isSymmetrical() {
        return true;
    }

    @Override
    public double random(IRandomNumberGenerator rng) {
        if (rng == null) {
            throw new DStatException("No valid Random Number Generator", "Normal");
        }
        return StochasticRandomizer.normal(rng, this.mean_, this.stdev_);
    }

    public void setMean(double mean) {
        this.mean_ = mean;
    }

    public void setStdev(double stdev) {
        if (stdev <= 0.0) {
            throw new DStatException("Invalid definition", "Normal");
        }
        this.stdev_ = stdev;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("N(");
        sb.append(new Formatter().format("%g4", this.mean_));
        sb.append(',');
        sb.append(new Formatter().format("%g4", this.stdev_));
        sb.append(')');
        return sb.toString();
    }
}

