/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.simplets;

import ec.benchmarking.DisaggregationModel;
import ec.benchmarking.simplets.TsDisaggregation;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.ssf.arima.SsfRw;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.LinearTrend;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

@Deprecated
public class Fernandez {
    private TsData m_res;
    private TsData m_s;
    private TsData m_es;
    private TsAggregationType m_type = TsAggregationType.Sum;
    private boolean m_zinit;
    private boolean m_trend;
    private DiffuseConcentratedLikelihood m_ll;

    public boolean process(TsData y, TsFrequency freq, int nfcasts) {
        this.clear();
        int yfreq = y.getFrequency().intValue();
        int ifreq = freq.intValue();
        if (ifreq % yfreq != 0) {
            return false;
        }
        int conv = ifreq / yfreq;
        DisaggregationModel model = new DisaggregationModel(freq);
        model.setY(y);
        if (this.m_trend) {
            model.getX().add(new LinearTrend(y.getStart().firstday()));
        }
        model.setAggregationType(this.m_type);
        TsDisaggregation<SsfRw> disagg = this.algorithm();
        TsDomain ndom = new TsDomain(freq, y.getStart().getYear(), y.getStart().getPosition() * conv, y.getLength() * conv + nfcasts);
        if (!disagg.process(model, ndom)) {
            return false;
        }
        this.analyse(disagg);
        return this.m_ll != null;
    }

    public boolean process(TsData y, TsVariableList x) {
        this.clear();
        if (x == null) {
            return false;
        }
        DisaggregationModel model = new DisaggregationModel(TsFrequency.Undefined);
        model.setY(y);
        if (this.m_trend) {
            model.getX().add(new LinearTrend(y.getStart().firstday()));
        }
        for (ITsVariable var : x.items()) {
            model.getX().add(var);
        }
        model.setAggregationType(this.m_type);
        int xfreq = x.getFrequency().intValue();
        int yfreq = y.getFrequency().intValue();
        if (xfreq == 0 || xfreq % yfreq != 0) {
            return false;
        }
        TsDisaggregation<SsfRw> disagg = this.algorithm();
        if (!disagg.process(model, null)) {
            return false;
        }
        this.analyse(disagg);
        return this.m_ll != null;
    }

    private void analyse(TsDisaggregation<SsfRw> disagg) {
        this.m_s = disagg.getSmoothedSeries();
        this.m_es = disagg.getSmoothedSeriesVariance().sqrt();
        this.m_ll = disagg.getLikelihood();
        this.m_res = disagg.getFullResiduals();
    }

    private TsDisaggregation<SsfRw> algorithm() {
        SsfRw rw = new SsfRw();
        rw.useZeroInitialization(this.m_zinit);
        TsDisaggregation<SsfRw> disagg = new TsDisaggregation<SsfRw>();
        disagg.setSsf(rw);
        disagg.calculateVariance(true);
        return disagg;
    }

    private void clear() {
        this.m_s = null;
        this.m_es = null;
        this.m_ll = null;
    }

    public TsData getResiduals() {
        return this.m_res;
    }

    public boolean isTrend() {
        return this.m_trend;
    }

    public void setTrend(boolean value) {
        this.m_trend = value;
    }

    public TsAggregationType getAggregationType() {
        return this.m_type;
    }

    public void setAggregationType(TsAggregationType value) {
        this.m_type = value;
    }

    public boolean isZeroInitialization() {
        return this.m_zinit;
    }

    public void setZeroInitialization(boolean value) {
        this.m_zinit = value;
    }

    public LikelihoodStatistics getLikelihoodStatistics() {
        if (this.m_ll == null) {
            return null;
        }
        LikelihoodStatistics stats = LikelihoodStatistics.create(this.m_ll, this.m_ll.getN(), 0, 0.0);
        return stats;
    }

    public DiffuseConcentratedLikelihood getLikelihood() {
        return this.m_ll;
    }

    public TsData getDisaggregatedSeries() {
        return this.m_s;
    }

    public TsData getDisaggregatedSeriesStde() {
        return this.m_es;
    }
}

