% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_workspace.R
\name{save_workspace}
\alias{save_workspace}
\title{Save a workspace}
\usage{
save_workspace(workspace, file)
}
\arguments{
\item{workspace}{a workspace object to export}

\item{file}{the path to the export 'JDemetra+' workspace (.xml file).
By default a dialog box opens.}
}
\value{
A boolean indicating whether the export has suceed.
}
\description{
Functions save a \code{workspace} object into a 'JDemetra+'' workspace.
}
\examples{
\donttest{
dir <- tempdir()
# Create and export a empty 'JDemetra+' workspace
wk <- new_workspace()
new_multiprocessing(wk, "sa1")
save_workspace(wk, file.path(dir, "workspace.xml"))
}

}
\seealso{
\code{\link{load_workspace}}
}
