/*
 * Decompiled with CFR 0.152.
 */
package jdr.spec.ts;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.TsVariable;
import ec.tstoolkit.timeseries.regression.TsVariables;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Utility {
    public static final String R = "r";
    public static final String RPREFIX = "r@";

    public static Day of(String date) {
        try {
            return Day.fromString((String)date);
        }
        catch (ParseException ex) {
            throw new RuntimeException("Unvalid date format");
        }
    }

    public static String toString(Date date) {
        return new Day(date).toString();
    }

    public static String toString(Day day) {
        return day == null || day == Day.BEG || day == Day.END ? "" : day.toString();
    }

    public static Parameter[] parameters(double[] values) {
        return Utility.parameters(values, null);
    }

    public static Parameter[] parameters(double[] values, boolean[] fixed) {
        Parameter[] p = new Parameter[values.length];
        for (int i = 0; i < p.length; ++i) {
            if (Double.isFinite(values[i])) {
                if (fixed != null && fixed[i]) {
                    p[i] = new Parameter(values[i], ParameterType.Fixed);
                    continue;
                }
                p[i] = new Parameter(values[i], ParameterType.Initial);
                continue;
            }
            p[i] = new Parameter();
        }
        return p;
    }

    public static String outlierName(String code, String date, int frequency) {
        StringBuilder builder = new StringBuilder();
        builder.append(code).append(" (");
        if (frequency == 0) {
            builder.append(date);
        } else {
            TsPeriod p = new TsPeriod(TsFrequency.valueOf((int)frequency), Utility.of(date));
            builder.append(p);
        }
        return builder.append(')').toString();
    }

    private Utility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Dictionary {
        private final Map<String, TsData> dictionary = new LinkedHashMap<String, TsData>();

        public void add(String name, TsData s) {
            this.dictionary.put(name, s);
        }

        public String[] names() {
            return this.dictionary.keySet().toArray(new String[this.dictionary.size()]);
        }

        public TsData get(String name) {
            return this.dictionary.get(name);
        }

        public ProcessingContext toContext() {
            ProcessingContext context = new ProcessingContext();
            if (!this.dictionary.isEmpty()) {
                TsVariables vars = new TsVariables();
                this.dictionary.forEach((n, s) -> vars.set(n, (Object)new TsVariable(n, s)));
                context.getTsVariableManagers().set(Utility.R, (Object)vars);
            }
            return context;
        }

        public static Dictionary fromContext(ProcessingContext context) {
            Dictionary dic = new Dictionary();
            if (context == null) {
                return dic;
            }
            String[] vars = context.getTsVariableManagers().getNames();
            for (int i = 0; i < vars.length; ++i) {
                String[] names;
                TsVariables cur = context.getTsVariables(vars[i]);
                for (String name : names = cur.getNames()) {
                    TsVariable v = (TsVariable)cur.get(name);
                    TsData d = v.getTsData();
                    if (d == null) continue;
                    if (vars[i].equals(Utility.R)) {
                        dic.add(name, d);
                        continue;
                    }
                    StringBuilder lname = new StringBuilder();
                    lname.append(vars[i]).append('@').append(name);
                    dic.add(lname.toString(), d);
                }
            }
            return dic;
        }
    }

    public static final class UserDefinedVariable {
        private final String name;
        private final String component;
        private final double coefficient;

        public UserDefinedVariable(String name, String component, double coefficient) {
            this.name = name;
            this.component = component;
            this.coefficient = coefficient;
        }

        public String getName() {
            return this.name;
        }

        public String getComponent() {
            return this.component;
        }

        public double getCoefficient() {
            return this.coefficient;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserDefinedVariable)) {
                return false;
            }
            UserDefinedVariable other = (UserDefinedVariable)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$component = this.getComponent();
            String other$component = other.getComponent();
            if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
                return false;
            }
            return Double.compare(this.getCoefficient(), other.getCoefficient()) == 0;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $component = this.getComponent();
            result = result * 59 + ($component == null ? 43 : $component.hashCode());
            long $coefficient = Double.doubleToLongBits(this.getCoefficient());
            result = result * 59 + (int)($coefficient >>> 32 ^ $coefficient);
            return result;
        }

        public String toString() {
            return "Utility.UserDefinedVariable(name=" + this.getName() + ", component=" + this.getComponent() + ", coefficient=" + this.getCoefficient() + ")";
        }
    }

    public static final class Ramp {
        private final String start;
        private final String end;
        private final double coefficient;

        public Ramp(String start, String end, double coefficient) {
            this.start = start;
            this.end = end;
            this.coefficient = coefficient;
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }

        public double getCoefficient() {
            return this.coefficient;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ramp)) {
                return false;
            }
            Ramp other = (Ramp)o;
            String this$start = this.getStart();
            String other$start = other.getStart();
            if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
                return false;
            }
            String this$end = this.getEnd();
            String other$end = other.getEnd();
            if (this$end == null ? other$end != null : !this$end.equals(other$end)) {
                return false;
            }
            return Double.compare(this.getCoefficient(), other.getCoefficient()) == 0;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            String $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : $end.hashCode());
            long $coefficient = Double.doubleToLongBits(this.getCoefficient());
            result = result * 59 + (int)($coefficient >>> 32 ^ $coefficient);
            return result;
        }

        public String toString() {
            return "Utility.Ramp(start=" + this.getStart() + ", end=" + this.getEnd() + ", coefficient=" + this.getCoefficient() + ")";
        }
    }

    public static final class Outlier {
        private final String code;
        private final String position;
        private final double coefficient;

        public Outlier(String code, String position, double coefficient) {
            this.code = code;
            this.position = position;
            this.coefficient = coefficient;
        }

        public String getCode() {
            return this.code;
        }

        public String getPosition() {
            return this.position;
        }

        public double getCoefficient() {
            return this.coefficient;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Outlier)) {
                return false;
            }
            Outlier other = (Outlier)o;
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$position = this.getPosition();
            String other$position = other.getPosition();
            if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
                return false;
            }
            return Double.compare(this.getCoefficient(), other.getCoefficient()) == 0;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : $position.hashCode());
            long $coefficient = Double.doubleToLongBits(this.getCoefficient());
            result = result * 59 + (int)($coefficient >>> 32 ^ $coefficient);
            return result;
        }

        public String toString() {
            return "Utility.Outlier(code=" + this.getCode() + ", position=" + this.getPosition() + ", coefficient=" + this.getCoefficient() + ")";
        }
    }
}

