/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class TextReader
implements PlugIn {
    int words = 0;
    int chars = 0;
    int lines = 0;
    int width = 1;
    String directory;
    String name;
    String path;
    boolean hideErrorMessages;

    public void run(String string) {
        if (this.showDialog()) {
            IJ.showStatus("Opening: " + this.path);
            ImageProcessor imageProcessor = this.open(this.path);
            if (imageProcessor != null) {
                new ImagePlus(this.name, imageProcessor).show();
            }
        }
    }

    boolean showDialog() {
        OpenDialog openDialog = new OpenDialog("Open Text Image...", null);
        this.directory = openDialog.getDirectory();
        this.name = openDialog.getFileName();
        if (this.name != null) {
            this.path = this.directory + this.name;
        }
        return this.name != null;
    }

    public ImageProcessor open() {
        if (this.showDialog()) {
            return this.open(this.path);
        }
        return null;
    }

    public ImageProcessor open(String string) {
        FloatProcessor floatProcessor = null;
        try {
            this.lines = 0;
            this.chars = 0;
            this.words = 0;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.countLines(bufferedReader);
            ((Reader)bufferedReader).close();
            bufferedReader = new BufferedReader(new FileReader(string));
            float[] fArray = new float[this.width * this.lines];
            floatProcessor = new FloatProcessor(this.width, this.lines, fArray, null);
            this.read(bufferedReader, this.width * this.lines, fArray);
            ((Reader)bufferedReader).close();
            ((ImageProcessor)floatProcessor).resetMinAndMax();
        }
        catch (IOException iOException) {
            String string2 = iOException.getMessage();
            if (string2 == null || string2.equals("")) {
                string2 = "" + iOException;
            }
            IJ.showProgress(1.0);
            if (!this.hideErrorMessages) {
                IJ.error("TextReader", string2);
            }
            floatProcessor = null;
        }
        return floatProcessor;
    }

    public void hideErrorMessages() {
        this.hideErrorMessages = true;
    }

    public String getName() {
        return this.name;
    }

    void countLines(Reader reader) throws IOException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        int n = 0;
        int n2 = 0;
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(45, 127);
        streamTokenizer.whitespaceChars(0, 42);
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.whitespaceChars(128, 255);
        streamTokenizer.eolIsSignificant(true);
        while (streamTokenizer.nextToken() != -1) {
            switch (streamTokenizer.ttype) {
                case 10: {
                    ++this.lines;
                    if (n == 0) {
                        --this.lines;
                    }
                    if (this.lines == 1) {
                        this.width = n;
                    } else if (n != 0 && n != n2) {
                        throw new IOException("Line " + this.lines + " is not the same length as the first line.");
                    }
                    if (n != 0) {
                        n2 = n;
                    }
                    n = 0;
                    if (this.lines % 20 != 0 || this.width <= 1 || this.lines > this.width) break;
                    IJ.showProgress((double)this.lines / (double)this.width / 2.0);
                    break;
                }
                case -3: {
                    ++this.words;
                    ++n;
                }
            }
        }
        if (n == this.width) {
            ++this.lines;
        }
    }

    void read(Reader reader, int n, float[] fArray) throws IOException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(45, 127);
        streamTokenizer.whitespaceChars(0, 42);
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.whitespaceChars(128, 255);
        int n2 = 0;
        int n3 = n / 20;
        if (n3 < 1) {
            n3 = 1;
        }
        while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype != -3) continue;
            fArray[n2++] = (float)Tools.parseDouble(streamTokenizer.sval, 0.0);
            if (n2 == n) break;
            if (n2 % n3 != 0) continue;
            IJ.showProgress(0.5 + (double)n2 / (double)n / 2.0);
        }
        IJ.showProgress(1.0);
    }
}

