/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import java.awt.image.IndexColorModel;

public class LUT
extends IndexColorModel
implements Cloneable {
    public double min;
    public double max;

    public LUT(byte[] r, byte[] g, byte[] b) {
        this(8, 256, r, g, b);
    }

    public LUT(int bits, int size, byte[] r, byte[] g, byte[] b) {
        super(bits, size, r, g, b);
    }

    public LUT(IndexColorModel cm, double min, double max) {
        super(8, cm.getMapSize(), LUT.getReds(cm), LUT.getGreens(cm), LUT.getBlues(cm));
        this.min = min;
        this.max = max;
    }

    static byte[] getReds(IndexColorModel cm) {
        byte[] reds = new byte[256];
        cm.getReds(reds);
        return reds;
    }

    static byte[] getGreens(IndexColorModel cm) {
        byte[] greens = new byte[256];
        cm.getGreens(greens);
        return greens;
    }

    static byte[] getBlues(IndexColorModel cm) {
        byte[] blues = new byte[256];
        cm.getBlues(blues);
        return blues;
    }

    public byte[] getBytes() {
        int i;
        int size = this.getMapSize();
        if (size != 256) {
            return null;
        }
        byte[] bytes = new byte[768];
        for (i = 0; i < 256; ++i) {
            bytes[i] = (byte)this.getRed(i);
        }
        for (i = 0; i < 256; ++i) {
            bytes[256 + i] = (byte)this.getGreen(i);
        }
        for (i = 0; i < 256; ++i) {
            bytes[512 + i] = (byte)this.getBlue(i);
        }
        return bytes;
    }

    public LUT createInvertedLut() {
        int mapSize = this.getMapSize();
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        byte[] reds2 = new byte[mapSize];
        byte[] greens2 = new byte[mapSize];
        byte[] blues2 = new byte[mapSize];
        this.getReds(reds);
        this.getGreens(greens);
        this.getBlues(blues);
        for (int i = 0; i < mapSize; ++i) {
            reds2[i] = (byte)(reds[mapSize - i - 1] & 0xFF);
            greens2[i] = (byte)(greens[mapSize - i - 1] & 0xFF);
            blues2[i] = (byte)(blues[mapSize - i - 1] & 0xFF);
        }
        return new LUT(8, mapSize, reds2, greens2, blues2);
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

