/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Plot;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.Rectangle;

public class ZAxisProfiler
implements PlugInFilter,
Measurements {
    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        double maxThreshold;
        if (this.imp.getStackSize() < 2) {
            IJ.error("ZAxisProfiler", "This command requires a stack.");
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.isLine()) {
            IJ.error("ZAxisProfiler", "This command does not work with line selections.");
            return;
        }
        double minThreshold = ip.getMinThreshold();
        float[] y = this.getZAxisProfile(roi, minThreshold, maxThreshold = ip.getMaxThreshold());
        if (y != null) {
            String title;
            float[] x = new float[y.length];
            for (int i = 0; i < x.length; ++i) {
                x[i] = i + 1;
            }
            if (roi != null) {
                Rectangle r = this.imp.getRoi().getBounds();
                title = this.imp.getTitle() + "-" + r.x + "-" + r.y;
            } else {
                title = this.imp.getTitle() + "-0-0";
            }
            Plot plot = new Plot(title, "Slice", "Mean", x, y);
            double ymin = ProfilePlot.getFixedMin();
            double ymax = ProfilePlot.getFixedMax();
            if (ymin != 0.0 || ymax != 0.0) {
                double[] a = Tools.getMinMax(x);
                double xmin = a[0];
                double xmax = a[1];
                plot.setLimits(xmin, xmax, ymin, ymax);
            }
            plot.show();
        }
    }

    float[] getZAxisProfile(Roi roi, double minThreshold, double maxThreshold) {
        ImageStack stack = this.imp.getStack();
        int size = stack.getSize();
        float[] values = new float[size];
        Calibration cal = this.imp.getCalibration();
        Analyzer analyzer = new Analyzer(this.imp);
        int measurements = analyzer.getMeasurements();
        boolean showResults = measurements != 0 && measurements != 256;
        boolean showingLabels = (measurements & 0x400) != 0 || (measurements & 0x100000) != 0;
        measurements |= 2;
        if (showResults) {
            if (!analyzer.resetCounter()) {
                return null;
            }
        }
        int current = this.imp.getCurrentSlice();
        for (int i = 1; i <= size; ++i) {
            if (showingLabels) {
                this.imp.setSlice(i);
            }
            ImageProcessor ip = stack.getProcessor(i);
            if (minThreshold != -808080.0) {
                ip.setThreshold(minThreshold, maxThreshold, 2);
            }
            ip.setRoi(roi);
            ImageStatistics stats = ImageStatistics.getStatistics(ip, measurements, cal);
            analyzer.saveResults(stats, roi);
            if (showResults) {
                analyzer.displayResults();
            }
            values[i - 1] = (float)stats.mean;
        }
        if (showingLabels) {
            this.imp.setSlice(current);
        }
        return values;
    }
}

