/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;

public class ListVirtualStack
extends VirtualStack
implements PlugIn {
    static boolean virtual;
    String[] list;
    int nImages;
    int imageWidth;
    int imageHeight;

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open Image List", arg);
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String dir = od.getDirectory();
        this.list = this.open(dir + name);
        this.nImages = this.list.length;
        if (this.list.length == 0) {
            IJ.error("Stack From List", "The file path list is empty");
            return;
        }
        File f = new File(this.list[0]);
        if (!f.exists()) {
            IJ.error("Stack From List", "The first file on the list does not exist:\n \n" + this.list[0]);
            return;
        }
        ImagePlus imp = IJ.openImage(this.list[0]);
        if (imp == null) {
            return;
        }
        this.imageWidth = imp.getWidth();
        this.imageHeight = imp.getHeight();
        ImageStack stack = this;
        if (!this.showDialog(imp)) {
            return;
        }
        if (!virtual) {
            stack = this.convertToRealStack(imp);
        }
        ImagePlus imp2 = new ImagePlus(name, stack);
        imp2.setCalibration(imp.getCalibration());
        imp2.show();
    }

    boolean showDialog(ImagePlus imp) {
        double bytesPerPixel = 1.0;
        switch (imp.getType()) {
            case 1: {
                bytesPerPixel = 2.0;
                break;
            }
            case 2: 
            case 4: {
                bytesPerPixel = 4.0;
            }
        }
        double size = (double)(this.imageWidth * this.imageHeight) * bytesPerPixel / 1048576.0;
        int digits = size * (double)this.getSize() < 10.0 ? 1 : 0;
        String size1 = IJ.d2s(size * (double)this.getSize(), digits) + " MB";
        String size2 = IJ.d2s(size, 1) + " MB";
        GenericDialog gd = new GenericDialog("Open Stack From List");
        gd.addCheckbox("Use Virtual Stack", virtual);
        gd.addMessage("This " + this.imageWidth + "x" + this.imageHeight + "x" + this.getSize() + " stack will require " + size1 + ",\n or " + size2 + " if opened as a virtual stack.");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        virtual = gd.getNextBoolean();
        return true;
    }

    ImageStack convertToRealStack(ImagePlus imp) {
        ImageStack stack2 = new ImageStack(this.imageWidth, this.imageHeight, imp.getProcessor().getColorModel());
        int n = this.getSize();
        for (int i = 1; i <= this.getSize(); ++i) {
            IJ.showProgress(i, n);
            IJ.showStatus("Opening: " + i + "/" + n);
            ImageProcessor ip2 = this.getProcessor(i);
            stack2.addSlice(null, ip2);
        }
        return stack2;
    }

    String[] open(String path) {
        Vector<String> v = new Vector<String>();
        File file = new File(path);
        try {
            String s;
            BufferedReader r = new BufferedReader(new FileReader(file));
            while ((s = r.readLine()) != null) {
                v.addElement(s);
            }
            r.close();
            Object[] list = new String[v.size()];
            v.copyInto(list);
            return list;
        }
        catch (Exception e) {
            IJ.error("Open List Error \n\"" + e.getMessage() + "\"\n");
            return null;
        }
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.nImages < 1) {
            return;
        }
        for (int i = n; i < this.nImages; ++i) {
            this.list[i - 1] = this.list[i];
        }
        this.list[this.nImages - 1] = null;
        --this.nImages;
    }

    public ImageProcessor getProcessor(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        ImagePlus imp = IJ.openImage(this.list[n - 1]);
        if (imp.getWidth() != this.imageWidth || imp.getHeight() != this.imageHeight) {
            IJ.error("List Virtual Stack", "Image dimensions do not match:\n \n" + this.list[n - 1]);
            return null;
        }
        if (imp != null) {
            return imp.getProcessor();
        }
        return null;
    }

    public int getSize() {
        return this.nImages;
    }

    public String getSliceLabel(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        return new File(this.list[n - 1]).getName();
    }

    public int getWidth() {
        return this.imageWidth;
    }

    public int getHeight() {
        return this.imageHeight;
    }
}

