% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_itch.R
\name{write_itch}
\alias{write_itch}
\title{Writes a data.frame or a list of data.frames of ITCH messages to file}
\usage{
write_itch(
  ll,
  file,
  add_meta = TRUE,
  append = FALSE,
  compress = FALSE,
  buffer_size = 1e+08,
  quiet = FALSE,
  append_warning = TRUE
)
}
\arguments{
\item{ll}{a data.frame or a list of data.frames of ITCH messages, in the format
that the \code{\link[=read_functions]{read_functions()}} return}

\item{file}{the filename of the target file. If the folder to the file does
not exist, it will be created recursively}

\item{add_meta}{if date and file information should be added to the filename.
Default value is TRUE. Note that adding meta information changes the filename.}

\item{append}{if the information should be appended to the file. Default value
is FALSE}

\item{compress}{if the file should be gzipped. Default value is FALSE.
Note that if you compress a file, buffer_size matters a lot, with larger
buffers you are more likely to get smaller filesizes in the end.
Alternatively, but slower, is to write the file without compression fully
and then gzip the file using another program.}

\item{buffer_size}{the maximum buffer size. Default value is 1e8 (100MB).
Accepted values are > 52 and < 5e9}

\item{quiet}{if TRUE, the status messages are suppressed, defaults to FALSE}

\item{append_warning}{if append is set, a warning about timestamp ordering is
given. Set \code{append_warning = FALSE} to silence the warning. Default
value is TRUE}
}
\value{
the filename (invisibly)
}
\description{
Note that additional information, e.g., columns that were added, will be
dropped in the process and only ITCH-compliant information is saved.
}
\details{
Note that the ITCH filename contains the information for the date and exchange.
This can be specified explicitly in the file argument or it is added if not
turned off \code{add_meta = FALSE}.
}
\examples{
infile <- system.file("extdata", "ex20101224.TEST_ITCH_50", package = "RITCH")
sys <- read_system_events(infile, quiet = TRUE)
outfile <- tempfile()
write_itch(sys, outfile)

# create a list of events, stock directory, and orders and write to a file
sdir <- read_stock_directory(infile, quiet = TRUE)
od   <- read_orders(infile, quiet = TRUE)

ll <- list(sys, sdir, od)
write_itch(ll, outfile)
}
