% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glrlm.R
\name{glrlm}
\alias{glrlm}
\title{Creates gray-level run length matrix from RIA image}
\usage{
glrlm(RIA_data_in, right = TRUE, down = FALSE, forward = FALSE,
  use_type = "single", use_orig = FALSE, use_slot = NULL,
  save_name = NULL, verbose_in = TRUE)
}
\arguments{
\item{RIA_data_in}{\emph{RIA_image}, created by \code{\link[RIA]{load_dicom}}.}

\item{right}{logical, indicating whether the direction should go to the right.}

\item{down}{logical, indicating whether the direction should go down.}

\item{forward}{logical, indicating whether the direction should in the cross plane.}

\item{use_type}{string, can be \emph{"single"} which runs the function on a single image,
which is determined using \emph{"use_orig"} or \emph{"use_slot"}. \emph{"dichotomized"}
takes all datasets in the \emph{RIA_image$dichotomized} slot and runs the analysis on them.}

\item{use_orig}{logical, indicating to use image present in \emph{RIA_data$orig}.
If FALSE, the modified image will be used stored in \emph{RIA_data$modif}.}

\item{use_slot}{string, name of slot where data wished to be used is. Use if the desired image
is not in the \emph{data$orig} or \emph{data$modif} slot of the \emph{RIA_image}. For example,
ig the desired dataset is in \emph{RIA_image$dichotomized$ep_4}, then \emph{use_slot} should be
\emph{dichotomized$ep_4}. The results are automatically saved. If the results are not saved to
the desired slot, then please use \emph{save_name} parameter.}

\item{save_name}{string, indicating the name of subslot of \emph{$glcm} to save results to.
If left empty, then it will be automatically determined based on the
last entry of \emph{RIA_image$log$events}.}

\item{verbose_in}{logical indicating whether to print detailed information.
Most prints can also be suppressed using the \code{\link{suppressMessages}} function.}
}
\value{
\emph{RIA_image} containing the GLRLM.
}
\description{
Creates gray-level run length matrix (GLRLM) from \emph{RIA_image}.
GLRLM assesses the spatial relation of voxels to each other by investigating how many times
same value voxels occur next to each other in a given direction. By default the \emph{$modif}
image will be used to calculate GLRLMs. If \emph{use_slot} is given, then the data
present in \emph{RIA_image$use_slot} will be used for calculations.
Results will be saved into the \emph{glrlm} slot. The name of the subslot is determined
by the supplied string in \emph{save_name}, or is automatically generated by RIA. \emph{right},
\emph{down} and \emph{forward} logicals are used to indicate the direction of the runs.
}
\examples{
\dontrun{
#Dichotomize loaded image and then calculate GLRLM matrix of RIA_image$modif
RIA_image <- dichotomize(RIA_image, bins_in = c(4, 8), equal_prob = TRUE,
use_orig = TRUE, write_orig = FALSE)
RIA_image <- glrlm(RIA_image, use_orig = FALSE, verbose_in = TRUE)

#Use use_slot parameter to set which image to use
RIA_image <- glrlm(RIA_image, use_orig = FALSE, use_slot = "dichotomized$ep_4",
right = TRUE, down = TRUE, forward = FALSE)

#Batch calculation of GLRLM matrices on all dichotomized images
RIA_image <- glrlm(RIA_image, use_type = "dichotomized",
right = TRUE, down = TRUE, forward = FALSE)
}
}
