/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.server.tasktracker.userlogs;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.TaskLogsTruncater;
import org.apache.hadoop.mapred.UserLogCleaner;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.DeleteJobEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JobCompletedEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JobStartedEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JvmFinishedEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.UserLogEvent;

public class UserLogManager {
    private static final Log LOG = LogFactory.getLog(UserLogManager.class);
    private BlockingQueue<UserLogEvent> userLogEvents = new LinkedBlockingQueue<UserLogEvent>();
    private TaskLogsTruncater taskLogsTruncater;
    private UserLogCleaner userLogCleaner;
    private Thread monitorLogEvents = new Thread(){

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        UserLogManager.this.monitor();
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)"Exception while monitoring user log events", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    };

    public UserLogManager(Configuration conf) throws IOException {
        this.taskLogsTruncater = new TaskLogsTruncater(conf);
        this.userLogCleaner = new UserLogCleaner(this, conf);
        this.monitorLogEvents.setDaemon(true);
    }

    public void start() {
        this.userLogCleaner.start();
        this.monitorLogEvents.start();
    }

    protected void monitor() throws Exception {
        UserLogEvent event = this.userLogEvents.take();
        this.processEvent(event);
    }

    protected void processEvent(UserLogEvent event) throws IOException {
        if (event instanceof JvmFinishedEvent) {
            this.doJvmFinishedAction((JvmFinishedEvent)event);
        } else if (event instanceof JobCompletedEvent) {
            this.doJobCompletedAction((JobCompletedEvent)event);
        } else if (event instanceof JobStartedEvent) {
            this.doJobStartedAction((JobStartedEvent)event);
        } else if (event instanceof DeleteJobEvent) {
            this.doDeleteJobAction((DeleteJobEvent)event);
        } else {
            LOG.warn((Object)("Unknown event " + (Object)((Object)event.getEventType()) + " passed."));
        }
    }

    public void clearOldUserLogs(Configuration conf) throws IOException {
        this.userLogCleaner.clearOldUserLogs(conf);
    }

    private void doJvmFinishedAction(JvmFinishedEvent event) {
        this.taskLogsTruncater.truncateLogs(event.getJvmInfo());
    }

    private void doJobStartedAction(JobStartedEvent event) {
        this.userLogCleaner.unmarkJobFromLogDeletion(event.getJobID());
    }

    private void doJobCompletedAction(JobCompletedEvent event) {
        this.userLogCleaner.markJobLogsForDeletion(event.getJobCompletionTime(), event.getRetainHours(), event.getJobID());
    }

    private void doDeleteJobAction(DeleteJobEvent event) throws IOException {
        this.userLogCleaner.deleteJobLogs(event.getJobID());
    }

    public void addLogEvent(UserLogEvent event) {
        this.userLogEvents.add(event);
    }

    public UserLogCleaner getUserLogCleaner() {
        return this.userLogCleaner;
    }
}

