/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.util.StringUtils;

public class DatanodeInfo
extends DatanodeID
implements Node {
    protected long capacity;
    protected long dfsUsed;
    protected long remaining;
    protected long lastUpdate;
    protected int xceiverCount;
    protected String location = "/default-rack";
    protected String hostName = null;
    protected AdminStates adminState;
    private int level;
    private Node parent;

    public DatanodeInfo() {
        this.adminState = null;
    }

    public DatanodeInfo(DatanodeInfo from) {
        super(from);
        this.capacity = from.getCapacity();
        this.dfsUsed = from.getDfsUsed();
        this.remaining = from.getRemaining();
        this.lastUpdate = from.getLastUpdate();
        this.xceiverCount = from.getXceiverCount();
        this.location = from.getNetworkLocation();
        this.adminState = from.adminState;
        this.hostName = from.hostName;
    }

    public DatanodeInfo(DatanodeID nodeID) {
        super(nodeID);
        this.capacity = 0L;
        this.dfsUsed = 0L;
        this.remaining = 0L;
        this.lastUpdate = 0L;
        this.xceiverCount = 0;
        this.adminState = null;
    }

    protected DatanodeInfo(DatanodeID nodeID, String location, String hostName) {
        this(nodeID);
        this.location = location;
        this.hostName = hostName;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getDfsUsed() {
        return this.dfsUsed;
    }

    public long getNonDfsUsed() {
        long nonDFSUsed = this.capacity - this.dfsUsed - this.remaining;
        return nonDFSUsed < 0L ? 0L : nonDFSUsed;
    }

    public float getDfsUsedPercent() {
        if (this.capacity <= 0L) {
            return 100.0f;
        }
        return (float)this.dfsUsed * 100.0f / (float)this.capacity;
    }

    public long getRemaining() {
        return this.remaining;
    }

    public float getRemainingPercent() {
        if (this.capacity <= 0L) {
            return 0.0f;
        }
        return (float)this.remaining * 100.0f / (float)this.capacity;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public int getXceiverCount() {
        return this.xceiverCount;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public void setRemaining(long remaining) {
        this.remaining = remaining;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setXceiverCount(int xceiverCount) {
        this.xceiverCount = xceiverCount;
    }

    @Override
    public synchronized String getNetworkLocation() {
        return this.location;
    }

    @Override
    public synchronized void setNetworkLocation(String location) {
        this.location = NodeBase.normalize(location);
    }

    public String getHostName() {
        return this.hostName == null || this.hostName.length() == 0 ? this.getHost() : this.hostName;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public String getDatanodeReport() {
        StringBuffer buffer = new StringBuffer();
        long c = this.getCapacity();
        long r = this.getRemaining();
        long u = this.getDfsUsed();
        long nonDFSUsed = this.getNonDfsUsed();
        float usedPercent = this.getDfsUsedPercent();
        float remainingPercent = this.getRemainingPercent();
        buffer.append("Name: " + this.name + "\n");
        if (!"/default-rack".equals(this.location)) {
            buffer.append("Rack: " + this.location + "\n");
        }
        buffer.append("Decommission Status : ");
        if (this.isDecommissioned()) {
            buffer.append("Decommissioned\n");
        } else if (this.isDecommissionInProgress()) {
            buffer.append("Decommission in progress\n");
        } else {
            buffer.append("Normal\n");
        }
        buffer.append("Configured Capacity: " + c + " (" + StringUtils.byteDesc(c) + ")" + "\n");
        buffer.append("DFS Used: " + u + " (" + StringUtils.byteDesc(u) + ")" + "\n");
        buffer.append("Non DFS Used: " + nonDFSUsed + " (" + StringUtils.byteDesc(nonDFSUsed) + ")" + "\n");
        buffer.append("DFS Remaining: " + r + "(" + StringUtils.byteDesc(r) + ")" + "\n");
        buffer.append("DFS Used%: " + StringUtils.limitDecimalTo2(usedPercent) + "%\n");
        buffer.append("DFS Remaining%: " + StringUtils.limitDecimalTo2(remainingPercent) + "%\n");
        buffer.append("Last contact: " + new Date(this.lastUpdate) + "\n");
        return buffer.toString();
    }

    public String dumpDatanode() {
        StringBuffer buffer = new StringBuffer();
        long c = this.getCapacity();
        long r = this.getRemaining();
        long u = this.getDfsUsed();
        buffer.append(this.name);
        if (!"/default-rack".equals(this.location)) {
            buffer.append(" " + this.location);
        }
        if (this.isDecommissioned()) {
            buffer.append(" DD");
        } else if (this.isDecommissionInProgress()) {
            buffer.append(" DP");
        } else {
            buffer.append(" IN");
        }
        buffer.append(" " + c + "(" + StringUtils.byteDesc(c) + ")");
        buffer.append(" " + u + "(" + StringUtils.byteDesc(u) + ")");
        buffer.append(" " + StringUtils.limitDecimalTo2(1.0 * (double)u / (double)c * 100.0) + "%");
        buffer.append(" " + r + "(" + StringUtils.byteDesc(r) + ")");
        buffer.append(" " + new Date(this.lastUpdate));
        return buffer.toString();
    }

    public void startDecommission() {
        this.adminState = AdminStates.DECOMMISSION_INPROGRESS;
    }

    public void stopDecommission() {
        this.adminState = null;
    }

    public boolean isDecommissionInProgress() {
        return this.adminState == AdminStates.DECOMMISSION_INPROGRESS;
    }

    public boolean isDecommissioned() {
        return this.adminState == AdminStates.DECOMMISSIONED;
    }

    public void setDecommissioned() {
        this.adminState = AdminStates.DECOMMISSIONED;
    }

    AdminStates getAdminState() {
        if (this.adminState == null) {
            return AdminStates.NORMAL;
        }
        return this.adminState;
    }

    protected void setAdminState(AdminStates newState) {
        this.adminState = newState == AdminStates.NORMAL ? null : newState;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.ipcPort);
        out.writeLong(this.capacity);
        out.writeLong(this.dfsUsed);
        out.writeLong(this.remaining);
        out.writeLong(this.lastUpdate);
        out.writeInt(this.xceiverCount);
        Text.writeString(out, this.location);
        Text.writeString(out, this.hostName == null ? "" : this.hostName);
        WritableUtils.writeEnum(out, this.getAdminState());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.ipcPort = in.readShort() & 0xFFFF;
        this.capacity = in.readLong();
        this.dfsUsed = in.readLong();
        this.remaining = in.readLong();
        this.lastUpdate = in.readLong();
        this.xceiverCount = in.readInt();
        this.location = Text.readString(in);
        this.hostName = Text.readString(in);
        this.setAdminState(WritableUtils.readEnum(in, AdminStates.class));
    }

    static {
        WritableFactories.setFactory(DatanodeInfo.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new DatanodeInfo();
            }
        });
    }

    public static enum AdminStates {
        NORMAL,
        DECOMMISSION_INPROGRESS,
        DECOMMISSIONED;

    }
}

