/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.filecache;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.DefaultTaskController;
import org.apache.hadoop.util.StringUtils;

public class DistributedCache {
    public static final String CACHE_FILES_SIZES = "mapred.cache.files.filesizes";
    public static final String CACHE_ARCHIVES_SIZES = "mapred.cache.archives.filesizes";
    public static final String CACHE_ARCHIVES_TIMESTAMPS = "mapred.cache.archives.timestamps";
    public static final String CACHE_FILES_TIMESTAMPS = "mapred.cache.files.timestamps";
    public static final String CACHE_ARCHIVES = "mapred.cache.archives";
    public static final String CACHE_FILES = "mapred.cache.files";
    public static final String CACHE_LOCALARCHIVES = "mapred.cache.localArchives";
    public static final String CACHE_LOCALFILES = "mapred.cache.localFiles";
    public static final String CACHE_SYMLINK = "mapred.create.symlink";

    public static Path getLocalCache(URI cache, Configuration conf, Path baseDir, FileStatus fileStatus, boolean isArchive, long confFileStamp, Path currentWorkDir) throws IOException {
        return DistributedCache.getLocalCache(cache, conf, baseDir, fileStatus, isArchive, confFileStamp, currentWorkDir, true);
    }

    public static Path getLocalCache(URI cache, Configuration conf, Path baseDir, FileStatus fileStatus, boolean isArchive, long confFileStamp, Path currentWorkDir, boolean honorSymLinkConf) throws IOException {
        return new TrackerDistributedCacheManager(conf, new DefaultTaskController()).getLocalCache(cache, conf, baseDir.toString(), fileStatus, isArchive, confFileStamp, currentWorkDir, honorSymLinkConf, false);
    }

    public static Path getLocalCache(URI cache, Configuration conf, Path baseDir, boolean isArchive, long confFileStamp, Path currentWorkDir) throws IOException {
        return DistributedCache.getLocalCache(cache, conf, baseDir, null, isArchive, confFileStamp, currentWorkDir);
    }

    public static void releaseCache(URI cache, Configuration conf) throws IOException {
        int i;
        URI[] archives = DistributedCache.getCacheArchives(conf);
        URI[] files = DistributedCache.getCacheFiles(conf);
        String[] archivesTimestamps = DistributedCache.getArchiveTimestamps(conf);
        String[] filesTimestamps = DistributedCache.getFileTimestamps(conf);
        String timestamp = null;
        if (archives != null) {
            for (i = 0; i < archives.length; ++i) {
                if (!archives[i].equals(cache)) continue;
                timestamp = archivesTimestamps[i];
                break;
            }
        }
        if (timestamp == null && files != null) {
            for (i = 0; i < files.length; ++i) {
                if (!files[i].equals(cache)) continue;
                timestamp = filesTimestamps[i];
                break;
            }
        }
        if (timestamp == null) {
            throw new IOException("TimeStamp of the uri couldnot be found");
        }
        new TrackerDistributedCacheManager(conf, new DefaultTaskController()).releaseCache(cache, conf, Long.parseLong(timestamp));
    }

    @Deprecated
    public static String makeRelative(URI cache, Configuration conf) throws IOException {
        return new TrackerDistributedCacheManager(conf, new DefaultTaskController()).makeRelative(cache, conf);
    }

    public static FileStatus getFileStatus(Configuration conf, URI cache) throws IOException {
        FileSystem fileSystem = FileSystem.get(cache, conf);
        Path filePath = new Path(cache.getPath());
        return fileSystem.getFileStatus(filePath);
    }

    public static long getTimestamp(Configuration conf, URI cache) throws IOException {
        return DistributedCache.getFileStatus(conf, cache).getModificationTime();
    }

    public static void createAllSymlink(Configuration conf, File jobCacheDir, File workDir) throws IOException {
        TrackerDistributedCacheManager.createAllSymlink(conf, jobCacheDir, workDir);
    }

    private static String getFileSysName(URI url) {
        String fsname = url.getScheme();
        if ("hdfs".equals(fsname)) {
            String host = url.getHost();
            int port = url.getPort();
            return port == -1 ? host : host + ":" + port;
        }
        return null;
    }

    public static void setCacheArchives(URI[] archives, Configuration conf) {
        String sarchives = StringUtils.uriToString(archives);
        conf.set(CACHE_ARCHIVES, sarchives);
    }

    public static void setCacheFiles(URI[] files, Configuration conf) {
        String sfiles = StringUtils.uriToString(files);
        conf.set(CACHE_FILES, sfiles);
    }

    public static URI[] getCacheArchives(Configuration conf) throws IOException {
        return StringUtils.stringToURI(conf.getStrings(CACHE_ARCHIVES));
    }

    public static URI[] getCacheFiles(Configuration conf) throws IOException {
        return StringUtils.stringToURI(conf.getStrings(CACHE_FILES));
    }

    public static Path[] getLocalCacheArchives(Configuration conf) throws IOException {
        return StringUtils.stringToPath(conf.getStrings(CACHE_LOCALARCHIVES));
    }

    public static Path[] getLocalCacheFiles(Configuration conf) throws IOException {
        return StringUtils.stringToPath(conf.getStrings(CACHE_LOCALFILES));
    }

    public static String[] getArchiveTimestamps(Configuration conf) {
        return conf.getStrings(CACHE_ARCHIVES_TIMESTAMPS);
    }

    public static String[] getFileTimestamps(Configuration conf) {
        return conf.getStrings(CACHE_FILES_TIMESTAMPS);
    }

    public static void setArchiveTimestamps(Configuration conf, String timestamps) {
        conf.set(CACHE_ARCHIVES_TIMESTAMPS, timestamps);
    }

    public static void setFileTimestamps(Configuration conf, String timestamps) {
        conf.set(CACHE_FILES_TIMESTAMPS, timestamps);
    }

    public static void setLocalArchives(Configuration conf, String str) {
        conf.set(CACHE_LOCALARCHIVES, str);
    }

    public static void setLocalFiles(Configuration conf, String str) {
        conf.set(CACHE_LOCALFILES, str);
    }

    public static void addCacheArchive(URI uri, Configuration conf) {
        String archives = conf.get(CACHE_ARCHIVES);
        conf.set(CACHE_ARCHIVES, archives == null ? uri.toString() : archives + "," + uri.toString());
    }

    public static void addCacheFile(URI uri, Configuration conf) {
        String files = conf.get(CACHE_FILES);
        conf.set(CACHE_FILES, files == null ? uri.toString() : files + "," + uri.toString());
    }

    public static void addFileToClassPath(Path file, Configuration conf) throws IOException {
        DistributedCache.addFileToClassPath(file, conf, FileSystem.get(conf));
    }

    public static void addFileToClassPath(Path file, Configuration conf, FileSystem fs) throws IOException {
        String classpath = conf.get("mapred.job.classpath.files");
        conf.set("mapred.job.classpath.files", classpath == null ? file.toString() : classpath + System.getProperty("path.separator") + file.toString());
        URI uri = fs.makeQualified(file).toUri();
        DistributedCache.addCacheFile(uri, conf);
    }

    public static Path[] getFileClassPaths(Configuration conf) {
        String classpath = conf.get("mapred.job.classpath.files");
        if (classpath == null) {
            return null;
        }
        ArrayList<Object> list = Collections.list(new StringTokenizer(classpath, System.getProperty("path.separator")));
        Path[] paths = new Path[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            paths[i] = new Path((String)list.get(i));
        }
        return paths;
    }

    public static void addArchiveToClassPath(Path archive, Configuration conf) throws IOException {
        DistributedCache.addArchiveToClassPath(archive, conf, FileSystem.get(conf));
    }

    public static void addArchiveToClassPath(Path archive, Configuration conf, FileSystem fs) throws IOException {
        String classpath = conf.get("mapred.job.classpath.archives");
        conf.set("mapred.job.classpath.archives", classpath == null ? archive.toString() : classpath + System.getProperty("path.separator") + archive.toString());
        URI uri = fs.makeQualified(archive).toUri();
        DistributedCache.addCacheArchive(uri, conf);
    }

    public static Path[] getArchiveClassPaths(Configuration conf) {
        String classpath = conf.get("mapred.job.classpath.archives");
        if (classpath == null) {
            return null;
        }
        ArrayList<Object> list = Collections.list(new StringTokenizer(classpath, System.getProperty("path.separator")));
        Path[] paths = new Path[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            paths[i] = new Path((String)list.get(i));
        }
        return paths;
    }

    public static void createSymlink(Configuration conf) {
        conf.set(CACHE_SYMLINK, "yes");
    }

    public static boolean getSymlink(Configuration conf) {
        String result = conf.get(CACHE_SYMLINK);
        return "yes".equals(result);
    }

    public static boolean checkURIs(URI[] uriFiles, URI[] uriArchives) {
        if (uriFiles == null && uriArchives == null) {
            return true;
        }
        if (uriFiles != null) {
            for (int i = 0; i < uriFiles.length; ++i) {
                String frag2;
                int j;
                String frag1 = uriFiles[i].getFragment();
                if (frag1 == null) {
                    return false;
                }
                for (j = i + 1; j < uriFiles.length; ++j) {
                    frag2 = uriFiles[j].getFragment();
                    if (frag2 == null) {
                        return false;
                    }
                    if (!frag1.equalsIgnoreCase(frag2)) continue;
                    return false;
                }
                if (uriArchives == null) continue;
                for (j = 0; j < uriArchives.length; ++j) {
                    frag2 = uriArchives[j].getFragment();
                    if (frag2 == null) {
                        return false;
                    }
                    if (frag1.equalsIgnoreCase(frag2)) {
                        return false;
                    }
                    for (int k = j + 1; k < uriArchives.length; ++k) {
                        String frag3 = uriArchives[k].getFragment();
                        if (frag3 == null) {
                            return false;
                        }
                        if (!frag2.equalsIgnoreCase(frag3)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static void purgeCache(Configuration conf) throws IOException {
        new TrackerDistributedCacheManager(conf, new DefaultTaskController()).purgeCache();
    }
}

